/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JPanel;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreePanel<T>
extends JPanel {
    Dimension area = new Dimension(0, 0);
    public static int minAreaWidth = 175;
    public static int minAreaHeight = 80;
    ArrayList<T> treebank;
    String flatSentence;
    int sentenceNumber;
    int lastIndex;
    int fontSize = 15;
    int smallFontSize = 11;
    int fontDescendent;
    Font font;
    Font smallFont;
    FontMetrics metrics;
    int topMargin = 60;
    int bottomMargin = 60;
    int leftMargin = 20;
    int rightMargin = 20;
    int wordSpace = 10;
    int textTopMargin = 4;
    int levelSizeFactor = 2;
    int fontHight;
    int doubleFontHight;
    int levelSize;

    public abstract void loadTreebank(ArrayList<T> var1);

    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public abstract void render(Graphics2D var1);

    public int sentenceNumber() {
        return this.sentenceNumber();
    }

    public int increaseFontSize() {
        return ++this.fontSize;
    }

    public int decreaseFontSize() {
        if (this.fontSize == 1) {
            return 1;
        }
        return --this.fontSize;
    }

    public int nextSentence() {
        if (this.sentenceNumber == this.lastIndex) {
            this.sentenceNumber = 0;
            return 0;
        }
        return ++this.sentenceNumber;
    }

    public int previousSentence() {
        if (this.sentenceNumber == 0) {
            this.sentenceNumber = this.lastIndex;
            return this.sentenceNumber;
        }
        return --this.sentenceNumber;
    }

    public int goToSentence(int n) {
        if (n < 0) {
            this.sentenceNumber = 0;
            return 0;
        }
        if (n > this.lastIndex) {
            this.sentenceNumber = this.lastIndex;
            return this.sentenceNumber;
        }
        this.sentenceNumber = n;
        return this.sentenceNumber;
    }

    public void loadFont() {
        this.font = new Font("Serif", 0, this.fontSize);
        this.smallFont = new Font("Serif", 0, this.smallFontSize);
        this.metrics = this.getFontMetrics(this.font);
        this.fontDescendent = this.metrics.getDescent();
        this.fontHight = this.metrics.getHeight();
        this.doubleFontHight = 2 * this.fontHight;
        this.levelSize = this.fontHight * this.levelSizeFactor;
    }

    public void exportToEPS(File file) {
        try {
            EpsGraphics g2 = new EpsGraphics("Title", new FileOutputStream(file), 0, 0, (int)this.area.getWidth() + 2, (int)this.area.getHeight(), ColorMode.COLOR_RGB);
            this.render(g2);
            g2.flush();
            g2.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
    }

    public void exportToPDF(File selectedFile) {
        if (selectedFile.exists()) {
            selectedFile.delete();
        }
        Document document = new Document(new Rectangle((int)this.area.getWidth(), (int)this.area.getHeight()));
        try {
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(selectedFile));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D g2 = cb.createGraphics((int)this.area.getWidth(), (int)this.area.getHeight());
            this.render(g2);
            g2.dispose();
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        document.close();
    }

    public void exportAllToPdf(File outputFile) {
        if (outputFile.exists()) {
            outputFile.delete();
        }
        int currentSentence = this.sentenceNumber;
        Color bgColor = new Color(255, 222, 173);
        try {
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(outputFile));
            document.open();
            PdfContentByte cbL = writer.getDirectContent();
            this.sentenceNumber = 0;
            while (this.sentenceNumber < this.treebank.size()) {
                this.loadSentence();
                Rectangle r = new Rectangle((int)this.area.getWidth(), (int)this.area.getHeight());
                Chunk sentenceLabel = new Chunk("Sentence # " + (this.sentenceNumber + 1));
                sentenceLabel.setBackground(bgColor);
                document.setPageSize(r);
                document.newPage();
                document.add(sentenceLabel);
                Graphics2D g2 = cbL.createGraphics((int)this.area.getWidth(), (int)this.area.getHeight());
                this.render(g2);
                g2.dispose();
                ++this.sentenceNumber;
            }
            document.close();
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        this.sentenceNumber = currentSentence;
    }

    public abstract void loadSentence();
}

