/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import javax.swing.JCheckBox;
import tesniere.Box;
import tesniere.Word;
import util.FileUtil;
import util.Utility;
import viewer.TreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TesniereTreePanel
extends TreePanel<Box> {
    int sentenceLength;
    int boxCount;
    int[][] boxesBorders;
    int[] boxesDepths;
    int[] boxesCoordGapsAbove;
    Box[] boxesArray;
    Word[] wordsArray;
    String[] wordsArrayString;
    IdentityHashMap<Word, Box> wordBoxMapping;
    IdentityHashMap<Box, Integer> boxIndexTable;
    int[] XLeftArray;
    int[] YArray;
    int[] XMiddleArray;
    int[] wordLengthsArray;
    int interBorder = 4;
    int catBoxSize = 4;
    int coordGapYSize = 3 * this.catBoxSize;
    int coordGapXSize = 3 * this.catBoxSize;
    int spaceBetweenBoxes = this.wordSpace - 2 * this.interBorder;
    int halfSpaceBetweenBoxes = this.spaceBetweenBoxes / 2;
    Color coordColor = Color.orange;
    Color verbColor = Color.red;
    Color adverbColor = Color.orange;
    Color nounColor = Color.blue;
    Color adjColor = Color.green;
    Color[] colorsCat = new Color[]{this.verbColor, this.adverbColor, this.nounColor, this.adjColor};
    String[] lettersCat = new String[]{"V", "A", "N", "J"};
    public JCheckBox skewedLinesCheckBox;
    public JCheckBox displayCategories;
    public static boolean printOnCosoleCurrentTree;

    public TesniereTreePanel() {
        this.levelSizeFactor = 3;
    }

    public TesniereTreePanel(ArrayList<Box> treebank) {
        this.loadTreebank(treebank);
    }

    @Override
    public void loadTreebank(ArrayList<Box> treebank) {
        this.treebank = treebank;
        this.lastIndex = treebank.size() - 1;
        this.sentenceNumber = 0;
    }

    @Override
    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke());
        int i = 0;
        while (i < this.sentenceLength) {
            Word w = this.wordsArray[i];
            g2.setColor(w.isEmpty() ? Color.gray : Color.black);
            g2.drawString(w.getLex(), this.XLeftArray[i], this.YArray[i]);
            g2.setColor(Color.black);
            ++i;
        }
        i = 0;
        Box[] boxArray = this.boxesArray;
        int n = this.boxesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle r;
            Box b = boxArray[n2];
            int[] borders = this.boxesBorders[i];
            if (b.isJunctionBlock()) {
                g2.setColor(this.coordColor);
                g2.drawRect(borders[0], borders[1], borders[2], borders[3]);
                g2.setColor(Color.black);
            } else {
                g2.drawRect(borders[0], borders[1], borders[2], borders[3]);
            }
            int cat = b.derivedCat;
            if (cat != -1) {
                g2.setColor(this.colorsCat[cat]);
                r = new Rectangle(borders[4] - this.catBoxSize, borders[1] - this.catBoxSize, this.catBoxSize * 2, this.catBoxSize);
                g2.fill(r);
                g2.setColor(Color.black);
                if (this.displayCategories.isSelected()) {
                    g2.setFont(this.smallFont);
                    g2.drawString(this.lettersCat[cat], borders[4] + this.catBoxSize + 2, borders[1] - 2);
                }
                g2.setFont(this.font);
            }
            if ((cat = b.originalCat) != -1) {
                g2.setColor(this.colorsCat[cat]);
                r = new Rectangle(borders[4] - this.catBoxSize, borders[1] + borders[3], this.catBoxSize * 2, this.catBoxSize);
                g2.fill(r);
                g2.setColor(Color.black);
                if (this.displayCategories.isSelected()) {
                    g2.setFont(this.smallFont);
                    g2.drawString(this.lettersCat[cat], borders[4] + this.catBoxSize + 2, borders[1] + borders[3] + this.smallFontSize - 2);
                }
                g2.setFont(this.font);
            }
            if (b.dependents != null) {
                for (Box d : b.dependents) {
                    int dIndex = this.boxIndexTable.get(d);
                    int[] depBorders = this.boxesBorders[dIndex];
                    this.drawLine(depBorders[4], depBorders[1], borders[4], borders[1] + borders[3], g2);
                }
            }
            ++i;
            ++n2;
        }
    }

    private int[] getBorders(Box b) {
        int height;
        int y;
        int width;
        int x;
        if (b.isJunctionBlock()) {
            int currentBoxGapsAbove;
            int lowestBoxGapsAbove;
            int startIndex = b.startPosition(false, false, true);
            int endIndex = b.endPosition(false, false, true);
            int extraXGapsRight = b.junctionBoxDownHavingRightmostWord(this.wordsArray[endIndex], true);
            int extraXGapsLeft = b.junctionBoxDownHavingLeftmostWord(this.wordsArray[startIndex], true);
            x = this.XLeftArray[startIndex] - this.interBorder - this.halfSpaceBetweenBoxes - (1 + extraXGapsLeft) * this.coordGapXSize;
            width = this.XLeftArray[endIndex] + this.wordLengthsArray[endIndex] - x + this.interBorder + this.halfSpaceBetweenBoxes + (1 + extraXGapsRight) * this.coordGapXSize;
            Box lowestBox = this.getLowestBox(b);
            int lowerBoxDepth = this.boxesDepths[this.boxIndexTable.get(lowestBox)];
            int indexLowestWord = lowestBox.startPosition();
            Word upperWord = b.getUpperWord();
            Box boxOfUpperWord = this.wordBoxMapping.get(upperWord);
            int coordGapAbove = boxOfUpperWord.numberOfCoordinationGapsAboveBeforeReaching(b);
            int indexUpperWord = upperWord.getPosition();
            y = this.YArray[indexUpperWord] - this.fontSize - this.interBorder - coordGapAbove * this.coordGapYSize;
            int coordGapLow = b.getInnerMaxCoordBox(lowerBoxDepth, false, false);
            int totalYGaps = coordGapAbove + coordGapLow + 1;
            if (coordGapLow > 0 && (lowestBoxGapsAbove = this.boxesCoordGapsAbove[this.boxIndexTable.get(lowestBox)]) - (currentBoxGapsAbove = this.boxesCoordGapsAbove[this.boxIndexTable.get(b)]) == totalYGaps) {
                --totalYGaps;
            }
            height = this.YArray[indexLowestWord] - this.YArray[indexUpperWord] + this.fontSize + this.fontDescendent + 2 * this.interBorder + totalYGaps * this.coordGapYSize;
        } else {
            Word lw = b.leftMostWord(false, false);
            Word rw = b.rightMostWord(false, false);
            int lwP = lw.getPosition();
            int rwP = rw.getPosition();
            x = this.XLeftArray[lwP] - this.interBorder;
            y = this.YArray[lwP] - this.fontSize - this.interBorder;
            width = this.XLeftArray[rwP] + this.wordLengthsArray[rwP] - x + this.interBorder;
            height = this.fontSize + 2 * this.interBorder + this.fontDescendent;
        }
        int middleX = x + width / 2;
        return new int[]{x, y, width, height, middleX};
    }

    private Box getLowestBox(Box b) {
        int maxDepth = -1;
        Box lowestBox = null;
        ArrayList lowestBoxes = b.getLowestBlocks();
        for (Box l : lowestBoxes) {
            int depth = this.YArray[l.getUpperWord().getPosition()];
            if (depth <= maxDepth) continue;
            maxDepth = depth;
            lowestBox = l;
        }
        return lowestBox;
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics2D g2) {
        y1 -= this.catBoxSize;
        y2 += this.catBoxSize;
        if (!this.skewedLinesCheckBox.isSelected()) {
            int yM = y1 + (y2 - y1) / 2;
            g2.drawLine(x1, y1, x1, yM);
            g2.drawLine(x1, yM, x2, yM);
            g2.drawLine(x2, yM, x2, y2);
        } else {
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.render(g2);
    }

    @Override
    public void loadSentence() {
        Word w;
        Box t = (Box)this.treebank.get(this.sentenceNumber);
        if (printOnCosoleCurrentTree) {
            System.out.println(t);
        }
        this.boxIndexTable = new IdentityHashMap();
        this.wordBoxMapping = new IdentityHashMap();
        this.boxCount = t.countAllNodes();
        this.sentenceLength = t.countAllWords();
        this.boxesBorders = new int[this.boxCount][];
        this.wordsArray = new Word[this.sentenceLength];
        this.wordsArrayString = new String[this.sentenceLength];
        t.fillWordArrayTable(this.wordsArray, this.wordBoxMapping);
        this.boxesArray = t.collectBoxStructure().toArray(new Box[this.boxCount]);
        this.boxesDepths = new int[this.boxCount];
        this.boxesCoordGapsAbove = new int[this.boxCount];
        Arrays.fill(this.boxesCoordGapsAbove, -1);
        int maxDepth = t.maxDepth();
        this.XLeftArray = new int[this.sentenceLength];
        this.XMiddleArray = new int[this.sentenceLength];
        this.wordLengthsArray = new int[this.sentenceLength];
        Arrays.fill(this.XLeftArray, -1);
        this.YArray = new int[this.sentenceLength];
        int treeWidth = 0;
        int previousWordLength = 0;
        int previousXLeft = this.leftMargin;
        int i = 0;
        while (i < this.boxCount) {
            Box b = this.boxesArray[i];
            this.boxIndexTable.put(b, i);
            this.boxesDepths[i] = b.getDepth();
            this.boxesCoordGapsAbove[i] = b.numberOfCoordinationGapsAbove();
            ++i;
        }
        int previousBoxDepth = -1;
        boolean previousIsRightmost = false;
        int previousExtraGapXCoord = 0;
        int j = 0;
        while (j < this.sentenceLength) {
            w = this.wordsArray[j];
            this.wordsArrayString[j] = w.getLex();
            Box boxW = this.wordBoxMapping.get(w);
            int boxWIndex = this.boxIndexTable.get(boxW);
            int coordGaps = this.boxesCoordGapsAbove[boxWIndex];
            int wDepths = this.boxesDepths[boxWIndex];
            int wordLength = this.metrics.stringWidth(w.getLex());
            boolean currentIsLeftmost = w == boxW.leftMostWord(false, false);
            boolean adjacentBlock = previousIsRightmost && currentIsLeftmost && wDepths == previousBoxDepth;
            this.wordLengthsArray[j] = wordLength;
            int currentExtraGapXCoord = boxW.junctionBoxUpHavingLeftmostWord(w);
            if (currentExtraGapXCoord > 0 && previousIsRightmost) {
                ++currentExtraGapXCoord;
            }
            this.XMiddleArray[j] = wordLength / 2 + previousXLeft + previousWordLength + this.wordSpace + (currentExtraGapXCoord + previousExtraGapXCoord) * this.coordGapXSize;
            if (adjacentBlock) {
                int n = j;
                this.XMiddleArray[n] = this.XMiddleArray[n] + this.wordSpace;
            }
            this.XLeftArray[j] = previousXLeft = this.XMiddleArray[j] - wordLength / 2;
            this.YArray[j] = this.topMargin + this.fontSize + wDepths * this.levelSize + coordGaps * this.coordGapYSize;
            if (w.isEmpty() && boxW.isJunctionBlock()) {
                int n = j;
                this.YArray[n] = this.YArray[n] + this.coordGapYSize;
            }
            previousWordLength = wordLength;
            if (j == this.sentenceLength - 1) {
                treeWidth = previousXLeft + previousWordLength + this.wordSpace;
            }
            previousBoxDepth = wDepths;
            previousIsRightmost = w == boxW.rightMostWord(false, false);
            previousExtraGapXCoord = boxW.junctionBoxUpHavingRightmostWord(w);
            if (previousExtraGapXCoord > 0 && currentIsLeftmost) {
                ++previousExtraGapXCoord;
            }
            ++j;
        }
        j = 0;
        while (j < this.sentenceLength) {
            w = this.wordsArray[j];
            if (w.isPunctuation() && j > 0) {
                this.YArray[j] = this.YArray[j - 1];
            }
            ++j;
        }
        int i2 = 0;
        while (i2 < this.boxCount) {
            Box b = this.boxesArray[i2];
            this.boxesBorders[i2] = this.getBorders(b);
            ++i2;
        }
        this.flatSentence = Utility.joinStringArrayToString(this.wordsArrayString, " ");
        int treeHeight = this.topMargin + this.fontSize + maxDepth * (this.levelSize + this.coordGapYSize) + this.bottomMargin;
        this.area.width = Math.max(treeWidth += this.rightMargin, minAreaWidth);
        this.area.height = Math.max(treeHeight, minAreaHeight);
    }

    public void exportAllToXML(File outputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        pw.println("<corpus id=\"Penn_WSJ_TDS_1.0\" >");
        int index = 1;
        for (Box t : this.treebank) {
            pw.println("\n<TDS id=\"tds_" + index + "\" >");
            pw.print(t.toXmlString(0));
            pw.println("</TDS>");
            ++index;
        }
        pw.println("\n</corpus>");
        pw.close();
    }
}

