/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tdg.DSConnl;
import util.FileUtil;
import viewer.DepTreePanelLabeled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepTreeViewerLabeled
extends JPanel
implements ChangeListener,
ActionListener {
    private DepTreePanelLabeled treePanel;
    private JPanel controlPanel;
    private JSpinner controlSentenceNumber;
    private JCheckBox straightLinesCheckBox;
    private JButton plus;
    private JButton minus;
    private JLabel sizeReport;
    static File corpusFile;
    private static DSConnl initialSentence;

    static {
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 1;
        initialSentence = new DSConnl(new String[]{"Load", "a", "corpus"}, new String[]{"V", "D", "N"}, nArray);
    }

    public DepTreeViewerLabeled() {
        super(new BorderLayout());
        ArrayList<DSConnl> treebank = new ArrayList<DSConnl>();
        treebank.add(initialSentence);
        this.buildComponents();
        JScrollPane scroller = new JScrollPane(this.treePanel);
        scroller.setPreferredSize(new Dimension(800, 600));
        this.add((Component)this.controlPanel, "North");
        this.add((Component)scroller, "Center");
        this.loadTreebank(treebank);
    }

    protected void loadTreebank(File treebankFile) {
        corpusFile = treebankFile;
        ArrayList treebank = DSConnl.getConnlTreeBank((File)treebankFile);
        this.loadTreebank(treebank);
    }

    private void loadTreebank(ArrayList<DSConnl> treebank) {
        int size = treebank.size();
        this.treePanel.loadTreebank((ArrayList)treebank);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1, 1, size, 1);
        this.controlSentenceNumber.setModel(spinnerModel);
        this.sizeReport.setText("of: " + size);
        this.treePanel.init();
    }

    private void buildComponents() {
        this.controlSentenceNumber = new JSpinner();
        this.controlSentenceNumber.setPreferredSize(new Dimension(100, 30));
        this.controlSentenceNumber.addChangeListener(this);
        this.controlSentenceNumber.setFocusable(true);
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setFocusable(false);
        JPanel leftControlPanel = new JPanel();
        JPanel centerControlPanel = new JPanel();
        JPanel rightControlPanel = new JPanel();
        this.controlPanel.add((Component)leftControlPanel, "West");
        this.controlPanel.add((Component)centerControlPanel, "Center");
        this.controlPanel.add((Component)rightControlPanel, "East");
        this.straightLinesCheckBox = new JCheckBox("Skewed Lines");
        this.straightLinesCheckBox.addActionListener(this);
        this.straightLinesCheckBox.setFocusable(false);
        leftControlPanel.add(this.straightLinesCheckBox);
        this.plus = new JButton("+");
        this.minus = new JButton("-");
        this.plus.addActionListener(this);
        this.minus.addActionListener(this);
        this.plus.setFocusable(false);
        this.minus.setFocusable(false);
        centerControlPanel.add(new JLabel("zoom: "));
        centerControlPanel.add(this.plus);
        centerControlPanel.add(this.minus);
        rightControlPanel.add(this.controlSentenceNumber);
        this.sizeReport = new JLabel();
        this.sizeReport.setFocusable(false);
        rightControlPanel.add(this.sizeReport);
        this.treePanel = new DepTreePanelLabeled();
        this.treePanel.setBackground(Color.white);
        this.treePanel.setFocusable(false);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Dependency Tree Viewer");
        frame.setDefaultCloseOperation(3);
        final DepTreeViewerLabeled treeViewer = new DepTreeViewerLabeled();
        treeViewer.setOpaque(true);
        frame.setContentPane(treeViewer);
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem openTreebank = new JMenuItem("Open Treebank");
        JMenuItem exportEps = new JMenuItem("Export to EPS");
        JMenuItem exportPdf = new JMenuItem("Export to PDF");
        JMenuItem exportOddsToPdf = new JMenuItem("Export loops to PDF");
        final JFileChooser fc = new JFileChooser();
        openTreebank.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        exportEps.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        exportPdf.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        openTreebank.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(treeViewer);
                File selectedFile = fc.getSelectedFile();
                if (returnVal == 0) {
                    treeViewer.loadTreebank(selectedFile);
                }
            }
        });
        exportEps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                File selectedFile = fc.getSelectedFile();
                selectedFile = FileUtil.changeExtention(selectedFile, "eps");
                if (returnVal == 0) {
                    treeViewer.treePanel.exportToEPS(selectedFile);
                }
            }
        });
        exportPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                File selectedFile = fc.getSelectedFile();
                selectedFile = FileUtil.changeExtention(selectedFile, "pdf");
                if (returnVal == 0) {
                    treeViewer.treePanel.exportToPDF(selectedFile);
                }
            }
        });
        exportOddsToPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                File selectedFile = fc.getSelectedFile();
                File loopFile = FileUtil.postpendAndChangeExtension(selectedFile, "_loops", "pdf");
                File nonProjFile = FileUtil.postpendAndChangeExtension(selectedFile, "_nonProj", "pdf");
                selectedFile = FileUtil.changeExtention(selectedFile, "pdf");
                if (returnVal == 0) {
                    treeViewer.treePanel.exportOddsToPdf(loopFile, nonProjFile, corpusFile);
                }
            }
        });
        file.add(openTreebank);
        file.add(exportEps);
        file.add(exportPdf);
        file.add(exportOddsToPdf);
        file.setMnemonic('F');
        file.setMnemonic('P');
        JMenuItem quit = new JMenuItem("Quit");
        file.add(quit);
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        JMenu window = new JMenu("Window");
        menuBar.add(file);
        menuBar.add(window);
        frame.setJMenuBar(menuBar);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Integer s = (Integer)this.controlSentenceNumber.getValue();
        this.treePanel.goToSentence(s - 1);
        this.treePanel.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        throw new Error("Unresolved compilation problems: \n\ttreePanel.straightLines cannot be resolved or is not a field\n\ttreePanel.straightLines cannot be resolved or is not a field\n");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DepTreeViewerLabeled.createAndShowGUI();
            }
        });
    }
}

