/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import tdg.TDNode;
import viewer.TreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepTreePanelOld
extends TreePanel {
    ArrayList<TDNode> treebank;
    int sentenceLength;
    TDNode[] nodesArray;
    String[] wordsArray;
    String[] posArray;
    int[] XLeftWordArray;
    int[] XLeftPosArray;
    int[] YArray;
    int[] XMiddleArray;

    public DepTreePanelOld(ArrayList<TDNode> treebank) {
        this.treebank = treebank;
        this.lastIndex = treebank.size() - 1;
    }

    @Override
    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int i = 0;
        while (i < this.sentenceLength) {
            g2.drawString(this.posArray[i], this.XLeftPosArray[i], this.YArray[i]);
            g2.drawString(this.wordsArray[i], this.XLeftWordArray[i], this.YArray[i] + this.fontHight);
            TDNode p = this.nodesArray[i].parent;
            if (p != null) {
                int pIndex = p.index;
                g2.drawLine(this.XMiddleArray[i], this.YArray[i] - this.fontSize - this.textTopMargin, this.XMiddleArray[pIndex], this.YArray[pIndex] + this.textTopMargin + this.fontHight);
            }
            ++i;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.render(g2);
    }

    @Override
    public void loadSentence() {
        TDNode t = this.treebank.get(this.sentenceNumber);
        this.nodesArray = t.getStructureArray();
        this.sentenceLength = this.nodesArray.length;
        this.wordsArray = new String[this.sentenceLength];
        this.posArray = new String[this.sentenceLength];
        this.XLeftWordArray = new int[this.sentenceLength];
        this.XLeftPosArray = new int[this.sentenceLength];
        this.XMiddleArray = new int[this.sentenceLength];
        this.YArray = new int[this.sentenceLength];
        int treeWidth = 0;
        int treeHeight = 0;
        int previousWordLength = 0;
        int previousXLeft = this.leftMargin;
        int i = 0;
        while (i < this.sentenceLength) {
            this.wordsArray[i] = this.nodesArray[i].lex;
            this.posArray[i] = this.nodesArray[i].postag;
            int wordLength = this.metrics.stringWidth(this.wordsArray[i]);
            int posLength = this.metrics.stringWidth(this.posArray[i]);
            int posWordLength = Math.max(wordLength, posLength);
            this.XMiddleArray[i] = posWordLength / 2 + previousXLeft + previousWordLength + this.wordSpace;
            this.XLeftWordArray[i] = this.XMiddleArray[i] - wordLength / 2;
            this.XLeftPosArray[i] = this.XMiddleArray[i] - posLength / 2;
            this.YArray[i] = this.topMargin + this.fontHight + this.nodesArray[i].depth() * this.levelSize;
            if (this.YArray[i] > treeHeight) {
                treeHeight = this.YArray[i];
            }
            if (i == this.sentenceLength - 1) {
                treeWidth = previousXLeft + previousWordLength + this.wordSpace + posWordLength;
            }
            previousWordLength = posWordLength;
            previousXLeft = this.XLeftWordArray[i];
            ++i;
        }
        this.area.width = treeWidth += this.leftMargin + this.rightMargin;
        this.area.height = treeHeight += this.bottomMargin;
    }

    public /* synthetic */ void loadTreebank(ArrayList arrayList) {
        throw new Error("Unresolved compilation problem: \n\tThe type DepTreePanelOld must implement the inherited abstract method TreePanel.loadTreebank(ArrayList)\n");
    }
}

