/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tsg.TSNodeLabel;
import util.FileUtil;
import viewer.ConstTreePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstTreeViewerInput
extends JPanel
implements ChangeListener,
ActionListener {
    private ConstTreePanel treePanel;
    private JPanel controlPanel;
    private JSpinner controlSentenceNumber;
    private JCheckBox straightLinesCheckBox;
    private JCheckBox showHeadsCheckBox;
    private JButton plus;
    private JButton minus;
    private JButton loadButton;
    private JLabel sizeReport;
    private JLabel statusBar;
    private JTextArea inputTextArea;
    private JScrollPane textAreaScollPane;
    private ArrayList<String> treebankComments;
    static String corpusString;
    JCheckBox[] optionCheckBoxs = new JCheckBox[]{new JCheckBox("Skewed Lines", false), new JCheckBox("Show Heads", false)};
    private static TSNodeLabel initialSentence;

    static {
        initialSentence = ConstTreeViewerInput.initialSentence();
    }

    public static TSNodeLabel initialSentence() {
        try {
            return new TSNodeLabel("(S (V Input) (NP (D a) (N treebank)))");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ConstTreeViewerInput() {
        super(new BorderLayout());
        ArrayList<TSNodeLabel> treebank = new ArrayList<TSNodeLabel>();
        this.treebankComments = new ArrayList();
        this.treebankComments.add("load a corpus");
        treebank.add(initialSentence);
        this.buildComponents();
        JScrollPane scroller = new JScrollPane(this.treePanel);
        scroller.setPreferredSize(new Dimension(800, 600));
        this.statusBar = new JLabel("Input a treebank");
        this.add((Component)this.controlPanel, "North");
        this.add((Component)scroller, "Center");
        this.add((Component)this.statusBar, "South");
        this.loadTreebank(treebank);
    }

    protected void loadTreebank(String treebankString) {
        corpusString = treebankString;
        ArrayList<TSNodeLabel> treebank = new ArrayList<TSNodeLabel>();
        this.treebankComments = new ArrayList();
        try {
            TSNodeLabel.getTreebankCommentFromString(treebankString, treebank, this.treebankComments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadTreebank(treebank);
    }

    private void loadTreebank(ArrayList<TSNodeLabel> treebank) {
        int size = treebank.size();
        this.treePanel.loadTreebank(treebank);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(1, 1, size, 1);
        this.controlSentenceNumber.setModel(spinnerModel);
        this.sizeReport.setText("of: " + size);
        this.statusBar.setText(this.treebankComments.get(0));
        this.treePanel.init();
    }

    private void buildComponents() {
        this.controlSentenceNumber = new JSpinner();
        this.controlSentenceNumber.setPreferredSize(new Dimension(100, 30));
        this.controlSentenceNumber.addChangeListener(this);
        this.controlSentenceNumber.setFocusable(true);
        this.controlPanel = new JPanel(new BorderLayout());
        this.controlPanel.setFocusable(false);
        JPanel leftControlPanel = new JPanel();
        JPanel centerControlPanel = new JPanel();
        JPanel rightControlPanel = new JPanel();
        JPanel bottomControlPanel = new JPanel();
        this.controlPanel.add((Component)leftControlPanel, "West");
        this.controlPanel.add((Component)centerControlPanel, "Center");
        this.controlPanel.add((Component)rightControlPanel, "East");
        this.controlPanel.add((Component)bottomControlPanel, "South");
        this.straightLinesCheckBox = new JCheckBox("Skewed Lines");
        this.straightLinesCheckBox.addActionListener(this);
        this.straightLinesCheckBox.setFocusable(false);
        leftControlPanel.add(this.straightLinesCheckBox);
        this.showHeadsCheckBox = new JCheckBox("Show Heads:");
        this.showHeadsCheckBox.addActionListener(this);
        this.showHeadsCheckBox.setFocusable(false);
        leftControlPanel.add(this.showHeadsCheckBox);
        this.plus = new JButton("+");
        this.minus = new JButton("-");
        this.plus.addActionListener(this);
        this.minus.addActionListener(this);
        this.plus.setFocusable(false);
        this.minus.setFocusable(false);
        centerControlPanel.add(new JLabel("zoom: "));
        centerControlPanel.add(this.plus);
        centerControlPanel.add(this.minus);
        rightControlPanel.add(this.controlSentenceNumber);
        this.sizeReport = new JLabel();
        this.sizeReport.setFocusable(false);
        rightControlPanel.add(this.sizeReport);
        this.inputTextArea = new JTextArea("(S (V Input) (NP (D a) (N treebank)))", 3, 80);
        this.inputTextArea.setLineWrap(true);
        this.textAreaScollPane = new JScrollPane(this.inputTextArea);
        this.loadButton = new JButton("Load");
        this.loadButton.addActionListener(this);
        this.loadButton.setFocusable(false);
        this.textAreaScollPane.setMaximumSize(new Dimension(500, 100));
        bottomControlPanel.add(this.textAreaScollPane);
        bottomControlPanel.add(this.loadButton);
        this.treePanel = new ConstTreePanel();
        this.treePanel.setBackground(Color.white);
        this.treePanel.setFocusable(false);
        this.treePanel.skewedLinesCheckBox = this.optionCheckBoxs[0];
        this.treePanel.showHeads = this.optionCheckBoxs[1];
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Constituency Tree Viewer Input");
        frame.setDefaultCloseOperation(3);
        final ConstTreeViewerInput treeViewer = new ConstTreeViewerInput();
        treeViewer.setOpaque(true);
        frame.setContentPane(treeViewer);
        JMenuBar menuBar = new JMenuBar();
        JMenu commands = new JMenu("Commands");
        JMenuItem exportEps = new JMenuItem("Export to EPS");
        JMenuItem exportPdf = new JMenuItem("Export to PDF");
        final JFileChooser fc = new JFileChooser();
        exportEps.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        exportPdf.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        exportEps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                File selectedFile = fc.getSelectedFile();
                selectedFile = FileUtil.changeExtention(selectedFile, "eps");
                if (returnVal == 0) {
                    treeViewer.treePanel.exportToEPS(selectedFile);
                }
            }
        });
        exportPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(treeViewer.treePanel);
                File selectedFile = fc.getSelectedFile();
                selectedFile = FileUtil.changeExtention(selectedFile, "pdf");
                if (returnVal == 0) {
                    treeViewer.treePanel.exportToPDF(selectedFile);
                }
            }
        });
        commands.add(exportEps);
        commands.add(exportPdf);
        commands.setMnemonic('F');
        commands.setMnemonic('P');
        JMenuItem quit = new JMenuItem("Quit");
        commands.add(quit);
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        JMenu window = new JMenu("Window");
        menuBar.add(commands);
        menuBar.add(window);
        frame.setJMenuBar(menuBar);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Integer s = (Integer)this.controlSentenceNumber.getValue();
        int index = s - 1;
        this.treePanel.goToSentence(index);
        this.statusBar.setText(this.treebankComments.get(index));
        this.treePanel.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.optionCheckBoxs[0] || source == this.optionCheckBoxs[1]) {
            this.treePanel.init();
            this.controlSentenceNumber.requestFocus();
            return;
        }
        if (source == this.loadButton) {
            this.loadTreebank(this.inputTextArea.getText());
        } else {
            int fs = source == this.plus ? this.treePanel.increaseFontSize() : this.treePanel.decreaseFontSize();
            System.out.println("Font size: " + fs);
        }
        this.treePanel.init();
        this.controlSentenceNumber.requestFocus();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConstTreeViewerInput.createAndShowGUI();
            }
        });
    }
}

