/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import tsg.TSNode;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static String defaultEncoding = "UTF-8";

    public static PrintWriter getPrintWriter(File outputFile, String encoding) {
        try {
            PrintWriter output = new PrintWriter(outputFile, encoding);
            return output;
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
            return null;
        }
    }

    public static PrintWriter getPrintWriter(File outputFile) {
        return FileUtil.getPrintWriter(outputFile, defaultEncoding);
    }

    public static void cleanFile(File outputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        pw.close();
    }

    public static Scanner getScanner(File inputFile, String encoding) {
        Scanner scan = null;
        try {
            scan = new Scanner(inputFile, encoding);
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
        return scan;
    }

    public static Scanner getScanner(File inputFile) {
        return FileUtil.getScanner(inputFile, defaultEncoding);
    }

    public static List<String> convertFileToStringList(File inputFile, String encoding) {
        ArrayList<String> list = new ArrayList<String>();
        Scanner scan = FileUtil.getScanner(inputFile, encoding);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if ((line = line.trim()).length() == 0) continue;
            line = line.replaceAll("\n", "");
            line = line.replaceAll("\\s+", " ");
            list.add(line);
        }
        scan.close();
        return list;
    }

    public static List<String> convertFileToStringList(File inputFile) {
        return FileUtil.convertFileToStringList(inputFile, defaultEncoding);
    }

    public static void append(String line, File fileName) {
        try {
            FileWriter OutputWriter = new FileWriter(fileName, true);
            OutputWriter.write(String.valueOf(line) + "\n");
            OutputWriter.close();
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    public static void clear(File fileName) {
        try {
            FileWriter OutputWriter = new FileWriter(fileName, false);
            OutputWriter.close();
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    public static String dataFolder() {
        Date d = new Date();
        String data = d.toString();
        data = data.substring(0, data.length() - 9);
        data = data.replace(' ', '_');
        data = data.replace(':', '_');
        return data;
    }

    public static void compareTreesInFiles(File fileA, File fileB) {
        LinkedList<String> linesA = FileUtil.getSentences(fileA, true);
        LinkedList<String> linesB = FileUtil.getSentences(fileB, true);
        if (linesA.size() != linesB.size()) {
            System.out.println("Unequal number of lines: " + linesA.size() + " " + linesB.size());
            return;
        }
        int i = 0;
        while (i < linesA.size()) {
            String lineA = linesA.get(i);
            String lineB = linesB.get(i);
            TSNode TNA = new TSNode(lineA, false);
            TSNode TNB = new TSNode(lineB, false);
            if (lineA.length() == 0 || lineB.length() == 0) {
                if (lineA.length() == 0 && lineB.length() == 0) {
                    System.out.println(String.valueOf(i) + ": OK");
                } else {
                    System.out.println(String.valueOf(i) + ": Length unmatch (one line is empty)");
                }
            } else {
                int lengthB;
                int lengthA = TNA.collectTerminals().size();
                if (lengthA != (lengthB = TNB.collectTerminals().size())) {
                    System.out.println(String.valueOf(i) + ": Length unmatch (" + lengthA + "|" + lengthB + ")");
                } else {
                    System.out.println(String.valueOf(i) + ": OK");
                }
            }
            ++i;
        }
    }

    public static void handleExceptions(Exception e) {
        e.printStackTrace();
        System.exit(-1);
    }

    public static LinkedList<String> getSentences(File file, boolean duplicate) {
        LinkedList<String> list = new LinkedList<String>();
        String line = "";
        try {
            FileReader InputReader = new FileReader(file);
            while (true) {
                int current;
                if ((current = InputReader.read()) == -1 || current == 10) {
                    if (duplicate || !list.contains(line)) {
                        list.add(line);
                    }
                    line = "";
                    if (current != -1) continue;
                    break;
                }
                line = String.valueOf(line) + (char)current;
            }
            InputReader.close();
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
        return list;
    }

    public static String getFirstLineInFile(File inputFile) {
        Scanner scan = FileUtil.getScanner(inputFile);
        if (!scan.hasNextLine()) {
            return null;
        }
        String line = scan.nextLine();
        scan.close();
        return line;
    }

    public static String getLineInFileStartingWith(File inputFile, String prefix) {
        Scanner scan = FileUtil.getScanner(inputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (!line.startsWith(prefix)) continue;
            scan.close();
            return line;
        }
        scan.close();
        return null;
    }

    public static void toBinaryFile(File outputFile, Object o) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFile));
            out.writeObject(o);
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    public static Object fromBinaryFile(File inputFile) {
        Object o = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(inputFile));
            o = in.readObject();
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
        return o;
    }

    public static Object fromBinaryInputStream(InputStream inputStream) {
        Object o = null;
        try {
            ObjectInputStream in = new ObjectInputStream(inputStream);
            o = in.readObject();
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
        return o;
    }

    public static void printHashtableToPw(Hashtable<String, Integer> table, PrintWriter writer) {
        Enumeration<String> e = table.keys();
        while (e.hasMoreElements()) {
            String rule = e.nextElement();
            Integer count = table.get(rule);
            writer.println(String.valueOf(count.toString()) + "\t" + rule);
        }
    }

    public static void printHashtableToFile(Hashtable<String, Integer> table, File outputFile) {
        PrintWriter writer = FileUtil.getPrintWriter(outputFile);
        FileUtil.printHashtableToPw(table, writer);
        writer.close();
    }

    public static void printHashtableToPwOrder(Hashtable<String, Integer> table, PrintWriter writer) {
        TreeSet<Integer> values = new TreeSet<Integer>(table.values());
        for (Integer i : values) {
            Enumeration<String> e = table.keys();
            while (e.hasMoreElements()) {
                String rule = e.nextElement();
                Integer count = table.get(rule);
                if (!count.equals(i)) continue;
                writer.println(String.valueOf(count.toString()) + "\t" + rule);
            }
        }
    }

    public static void printHashtableToFileOrder(Hashtable<String, Integer> table, File outputFile) {
        PrintWriter writer = FileUtil.getPrintWriter(outputFile);
        FileUtil.printHashtableToPwOrder(table, writer);
        writer.close();
    }

    public static File fileWithPadding(String filePath, String extension, int n) {
        int count = 1;
        File f = null;
        do {
            String padding = "" + count;
            padding = String.valueOf(Utility.fillChar(n - padding.length(), '0')) + padding;
            f = new File(String.valueOf(filePath) + padding + extension);
            ++count;
        } while (f.exists());
        return f;
    }

    public static File changeExtention(File selectedFile, String ext) {
        String extWithDot = "." + ext;
        String path = selectedFile.getParent();
        String fileName = selectedFile.getName();
        if (fileName.endsWith(extWithDot)) {
            return selectedFile;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex != -1) {
            fileName = fileName.substring(0, dotIndex);
        }
        fileName = String.valueOf(fileName) + extWithDot;
        selectedFile = new File(String.valueOf(path) + File.separator + fileName);
        return selectedFile;
    }

    public static File postpendAndChangeExtension(File selectedFile, String postpend, String ext) {
        String extWithDot = "." + ext;
        String path = selectedFile.getParent();
        String fileName = selectedFile.getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex != -1) {
            fileName = fileName.substring(0, dotIndex);
        }
        fileName = String.valueOf(fileName) + postpend + extWithDot;
        selectedFile = new File(String.valueOf(path) + File.separator + fileName);
        return selectedFile;
    }

    public static File appendAndAddExtention(File selectedFile, String toAdd, String ext) {
        String fileName = selectedFile.getName();
        int dotIndex = fileName.indexOf(46);
        if (dotIndex != -1) {
            fileName = fileName.substring(0, dotIndex);
        }
        fileName = String.valueOf(fileName) + toAdd;
        String path = selectedFile.getParent();
        selectedFile = new File(String.valueOf(path) + File.separator + fileName + "." + ext);
        return selectedFile;
    }

    public static File appendBeforeExtention(File selectedFile, String toAdd) {
        String originalName = selectedFile.getName();
        int dotIndex = originalName.lastIndexOf(46);
        String fileName = originalName;
        String extension = "";
        if (dotIndex != -1) {
            fileName = originalName.substring(0, dotIndex);
            extension = originalName.substring(dotIndex);
        }
        fileName = String.valueOf(fileName) + toAdd + extension;
        String path = selectedFile.getParent();
        selectedFile = new File(String.valueOf(path) + File.separator + fileName);
        return selectedFile;
    }

    public static String getFileNameWithoutExtensions(File testFile) {
        String fileName = testFile.getName();
        int dotIndex = fileName.indexOf(46);
        if (dotIndex == -1 || dotIndex == 0) {
            return fileName;
        }
        return fileName.substring(0, dotIndex);
    }

    public static void append(File inputFile, PrintWriter pwComplete) {
        Scanner scan = FileUtil.getScanner(inputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            pwComplete.println(line);
        }
        scan.close();
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.err.println("Lenght of the file in bytes bigger than 2147483647");
            return null;
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.dataFolder());
    }
}

