/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllOrderedStringExactSubsequences {
    public static final int maxComb = 1000000;
    Cell[][] cellMatrix;
    String[] a1;
    String[] a2;
    int xMax;
    int yMax;
    int xLength;
    int yLength;
    int lengthToMatch;
    int lengthToMatchMinusOne;
    int totalMatched;

    public AllOrderedStringExactSubsequences(String[] a1, String[] a2) {
        this.a1 = a1;
        this.a2 = a2;
        this.xLength = a1.length + 1;
        this.yLength = a2.length + 1;
        this.lengthToMatch = a2.length;
        this.lengthToMatchMinusOne = this.lengthToMatch - 1;
        this.xMax = a1.length;
        this.yMax = a2.length;
        this.cellMatrix = new Cell[this.xLength][this.yLength];
        int x = 0;
        while (x < this.xLength) {
            this.cellMatrix[x][0] = new Cell(x - 1, -1, false);
            ++x;
        }
        int y = 0;
        while (y < this.yLength) {
            this.cellMatrix[0][y] = new Cell(-1, y - 1, false);
            ++y;
        }
        x = 1;
        while (x < this.xLength) {
            int y2 = 1;
            while (y2 < this.yLength) {
                this.cellMatrix[x][y2] = new Cell(x - 1, y2 - 1, AllOrderedStringExactSubsequences.equal(a1[x - 1], a2[y2 - 1]));
                ++y2;
            }
            ++x;
        }
    }

    public static boolean equal(String a, String b) {
        return a.charAt(0) == b.charAt(0);
    }

    public static ArrayList<ArrayList<Pair<String>>> getallExactSubsequences(String[] t1, String[] t2) {
        if (t1.length < t2.length) {
            return null;
        }
        AllOrderedStringExactSubsequences O = new AllOrderedStringExactSubsequences(t1, t2);
        return O.getExactSubsequences();
    }

    public ArrayList<ArrayList<Pair<String>>> getExactSubsequences() {
        Cell c;
        if (this.totalMatched < this.lengthToMatch) {
            return null;
        }
        int firstindexXmatchFirstY = -1;
        int lastIndexXmatchLastY = -1;
        int x = 1;
        while (x < this.xLength) {
            if (this.cellMatrix[x][1].match) {
                firstindexXmatchFirstY = x;
                break;
            }
            ++x;
        }
        x = this.xMax;
        while (x >= this.yMax) {
            if (this.cellMatrix[x][this.yMax].match) {
                lastIndexXmatchLastY = x;
                break;
            }
            --x;
        }
        if (lastIndexXmatchLastY - firstindexXmatchFirstY + 1 < this.lengthToMatch) {
            return null;
        }
        boolean previousReachable = false;
        int x2 = 1;
        while (x2 < this.xLength) {
            Cell c2 = this.cellMatrix[x2][1];
            if (c2.match) {
                c2.maxSequenceLength = 1;
                previousReachable = true;
            } else if (previousReachable) {
                c2.leftReachable = true;
                c2.maxSequenceLength = 1;
                previousReachable = true;
            }
            ++x2;
        }
        int y = 2;
        while (y < this.yLength) {
            int x3 = 1;
            while (x3 < this.xLength) {
                int maxSL;
                c = this.cellMatrix[x3][y];
                Cell cl = this.cellMatrix[x3 - 1][y];
                int maxSequenceLenghtFromL = cl.maxSequenceLength;
                int maxSequenceLenghtFromD = 0;
                if (c.match) {
                    Cell cd = this.cellMatrix[x3 - 1][y - 1];
                    maxSequenceLenghtFromD = cd.maxSequenceLength + 1;
                }
                if ((maxSL = Math.max(maxSequenceLenghtFromL, maxSequenceLenghtFromD)) != 0) {
                    c.maxSequenceLength = maxSL;
                    if (maxSequenceLenghtFromL == maxSL) {
                        c.leftReachable = true;
                    }
                    if (maxSequenceLenghtFromD == maxSL) {
                        c.diagonalReachable = true;
                    }
                }
                ++x3;
            }
            ++y;
        }
        ArrayList<ArrayList<Pair<String>>> result = new ArrayList<ArrayList<Pair<String>>>();
        int x4 = 1;
        while (x4 < this.xLength) {
            c = this.cellMatrix[x4][this.yMax];
            if (c.match && c.maxSequenceLength == this.lengthToMatch) {
                c.addAllSubSequences(new ArrayList<Pair<String>>(), result);
            }
            ++x4;
        }
        return result;
    }

    public static void main(String[] args) {
        String[] a1 = new String[]{"A1", "B2", "A3"};
        String[] a2 = new String[]{"A1", "A2", "A3"};
        ArrayList<ArrayList<Pair<String>>> result = AllOrderedStringExactSubsequences.getallExactSubsequences(a1, a2);
        System.out.println(result.size());
        for (ArrayList<Pair<String>> pList : result) {
            System.out.println(pList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Cell {
        int x;
        int y;
        boolean match;
        boolean leftReachable;
        boolean diagonalReachable;
        int maxSequenceLength;

        protected Cell(int x, int y, boolean match) {
            this.x = x;
            this.y = y;
            if (match) {
                this.match = true;
                ++AllOrderedStringExactSubsequences.this.totalMatched;
            }
        }

        public void addAllSubSequences(ArrayList<Pair<String>> currentThread, ArrayList<ArrayList<Pair<String>>> result) {
            if (this.leftReachable) {
                if (this.diagonalReachable) {
                    ArrayList<Pair<String>> newThread = new ArrayList<Pair<String>>(currentThread);
                    AllOrderedStringExactSubsequences.this.cellMatrix[this.x][this.y + 1].addAllSubSequences(newThread, result);
                } else {
                    AllOrderedStringExactSubsequences.this.cellMatrix[this.x][this.y + 1].addAllSubSequences(currentThread, result);
                }
            }
            if (this.match) {
                currentThread.add(0, new Pair<String>(AllOrderedStringExactSubsequences.this.a1[this.x], AllOrderedStringExactSubsequences.this.a2[this.y]));
                if (this.y == 0) {
                    result.add(currentThread);
                    return;
                }
            }
            if (this.diagonalReachable) {
                AllOrderedStringExactSubsequences.this.cellMatrix[this.x][this.y].addAllSubSequences(currentThread, result);
            }
        }
    }
}

