/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import util.FileUtil;
import util.StringInteger;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertGrammarInBitParFormat {
    static String artificialNodePrefix = "###AN_";

    public static void deterministicGrammar(File completeGrammarFile, File grammarOut, File lexiconOut) {
        int artificialNodeCounter = 0;
        PrintWriter grammarPW = FileUtil.getPrintWriter(grammarOut);
        PrintWriter lexiconPW = FileUtil.getPrintWriter(lexiconOut);
        Hashtable<String, ArrayList<String>> lexiconPostags = new Hashtable<String, ArrayList<String>>();
        Scanner scan = FileUtil.getScanner(completeGrammarFile);
        while (scan.hasNextLine()) {
            String rule = scan.nextLine();
            if (rule.indexOf(34) == -1) {
                grammarPW.println(rule);
                continue;
            }
            String[] ruleSymbols = rule.split("\\s+");
            if (ruleSymbols.length == 2) {
                String postag = ruleSymbols[0];
                String word = ruleSymbols[1].replaceAll("\"", "");
                ConvertGrammarInBitParFormat.add(word, postag, lexiconPostags);
                continue;
            }
            String LHS = ruleSymbols[0];
            String[] nonTerminalRHS = new String[ruleSymbols.length - 1];
            int i = 1;
            while (i < ruleSymbols.length) {
                String nodeRHS = ruleSymbols[i];
                if (nodeRHS.indexOf(34) == -1) {
                    nonTerminalRHS[i - 1] = nodeRHS;
                } else {
                    String artificialPostag;
                    nonTerminalRHS[i - 1] = artificialPostag = String.valueOf(artificialNodePrefix) + ++artificialNodeCounter + "_";
                    String word = nodeRHS.replaceAll("\"", "");
                    ConvertGrammarInBitParFormat.add(word, artificialPostag, lexiconPostags);
                }
                ++i;
            }
            String artificialRule = String.valueOf(LHS) + " " + Utility.joinStringArrayToString(nonTerminalRHS, " ");
            grammarPW.println(artificialRule);
        }
        for (Map.Entry e : lexiconPostags.entrySet()) {
            lexiconPW.print((String)e.getKey());
            for (String postag : (ArrayList)e.getValue()) {
                lexiconPW.print("\t" + postag);
            }
            lexiconPW.println();
        }
        grammarPW.close();
        lexiconPW.close();
    }

    public static void deterministicGrammarForOneSentence(File completeGrammarFile, String sentence, File grammarOut, File lexiconOut) {
        String[] sentenceWords = sentence.split("\\s+");
        HashSet<String> sentenceWordsSet = new HashSet<String>();
        String[] stringArray = sentenceWords;
        int n = sentenceWords.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            sentenceWordsSet.add(w);
            ++n2;
        }
        int artificialNodeCounter = 0;
        PrintWriter grammarPW = FileUtil.getPrintWriter(grammarOut);
        PrintWriter lexiconPW = FileUtil.getPrintWriter(lexiconOut);
        Hashtable<String, ArrayList<String>> lexiconPostags = new Hashtable<String, ArrayList<String>>();
        Scanner scan = FileUtil.getScanner(completeGrammarFile);
        while (scan.hasNextLine()) {
            String rule = scan.nextLine();
            if (rule.indexOf(34) == -1) {
                grammarPW.println(rule);
                continue;
            }
            String[] ruleSymbols = rule.split("\\s+");
            if (ruleSymbols.length == 2) {
                String postag = ruleSymbols[0];
                String word = ruleSymbols[1].replaceAll("\"", "");
                if (!sentenceWordsSet.contains(word)) continue;
                ConvertGrammarInBitParFormat.add(word, postag, lexiconPostags);
                continue;
            }
            String LHS = ruleSymbols[0];
            String[] nonTerminalRHS = new String[ruleSymbols.length - 1];
            boolean allLexicalWordsAreInTheSentence = true;
            ArrayList<String[]> lexicalRules = new ArrayList<String[]>();
            int artificialNodeCounterTmp = artificialNodeCounter;
            int i = 1;
            while (i < ruleSymbols.length) {
                String nodeRHS = ruleSymbols[i];
                if (nodeRHS.indexOf(34) == -1) {
                    nonTerminalRHS[i - 1] = nodeRHS;
                } else {
                    String artificialPostag;
                    String word = nodeRHS.replaceAll("\"", "");
                    if (!sentenceWordsSet.contains(word)) {
                        allLexicalWordsAreInTheSentence = false;
                        break;
                    }
                    nonTerminalRHS[i - 1] = artificialPostag = String.valueOf(artificialNodePrefix) + ++artificialNodeCounter + "_";
                    lexicalRules.add(new String[]{word, artificialPostag});
                }
                ++i;
            }
            if (allLexicalWordsAreInTheSentence) {
                String artificialRule = String.valueOf(LHS) + " " + Utility.joinStringArrayToString(nonTerminalRHS, " ");
                grammarPW.println(artificialRule);
                for (String[] wordPos : lexicalRules) {
                    ConvertGrammarInBitParFormat.add(wordPos[0], wordPos[1], lexiconPostags);
                }
                continue;
            }
            artificialNodeCounter = artificialNodeCounterTmp;
        }
        for (Map.Entry e : lexiconPostags.entrySet()) {
            lexiconPW.print((String)e.getKey());
            for (String postag : (ArrayList)e.getValue()) {
                lexiconPW.print("\t" + postag);
            }
            lexiconPW.println();
        }
        grammarPW.close();
        lexiconPW.close();
    }

    public static void probGrammarForOneSentence(File completeGrammarFile, String[] sentenceWords, File grammarOut, File lexiconOut) {
        HashSet<String> sentenceWordsSet = new HashSet<String>();
        String[] stringArray = sentenceWords;
        int n = sentenceWords.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            sentenceWordsSet.add(w);
            ++n2;
        }
        int artificialNodeCounter = 0;
        PrintWriter grammarPW = FileUtil.getPrintWriter(grammarOut);
        PrintWriter lexiconPW = FileUtil.getPrintWriter(lexiconOut);
        Hashtable<String, ArrayList<StringInteger>> lexiconPostags = new Hashtable<String, ArrayList<StringInteger>>();
        Scanner scan = FileUtil.getScanner(completeGrammarFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            if (line.indexOf(34) == -1) {
                grammarPW.println(line);
                continue;
            }
            String[] lineSplit = line.split("\t");
            int freq = Integer.parseInt(lineSplit[0]);
            String rule = lineSplit[1];
            String[] ruleSymbols = rule.split("\\s+");
            if (ruleSymbols.length == 2) {
                String postag = ruleSymbols[0];
                String word = ruleSymbols[1].replaceAll("\"", "");
                StringInteger postagFreq = new StringInteger(postag, freq);
                if (!sentenceWordsSet.contains(word)) continue;
                ConvertGrammarInBitParFormat.addLexPosFreq(word, postagFreq, lexiconPostags);
                continue;
            }
            String LHS = ruleSymbols[0];
            String[] nonTerminalRHS = new String[ruleSymbols.length - 1];
            boolean allLexicalWordsAreInTheSentence = true;
            ArrayList<String[]> lexicalRules = new ArrayList<String[]>();
            int artificialNodeCounterTmp = artificialNodeCounter;
            int i = 1;
            while (i < ruleSymbols.length) {
                String nodeRHS = ruleSymbols[i];
                if (nodeRHS.indexOf(34) == -1) {
                    nonTerminalRHS[i - 1] = nodeRHS;
                } else {
                    String artificialPostag;
                    String word = nodeRHS.replaceAll("\"", "");
                    if (!sentenceWordsSet.contains(word)) {
                        allLexicalWordsAreInTheSentence = false;
                        break;
                    }
                    nonTerminalRHS[i - 1] = artificialPostag = String.valueOf(artificialNodePrefix) + ++artificialNodeCounter + "_";
                    lexicalRules.add(new String[]{word, artificialPostag});
                }
                ++i;
            }
            if (allLexicalWordsAreInTheSentence) {
                String artificialRule = String.valueOf(LHS) + " " + Utility.joinStringArrayToString(nonTerminalRHS, " ");
                grammarPW.println(String.valueOf(freq) + "\t" + artificialRule);
                for (String[] wordPos : lexicalRules) {
                    ConvertGrammarInBitParFormat.addLexPosFreq(wordPos[0], new StringInteger(wordPos[1], 1), lexiconPostags);
                }
                continue;
            }
            artificialNodeCounter = artificialNodeCounterTmp;
        }
        for (Map.Entry e : lexiconPostags.entrySet()) {
            lexiconPW.print((String)e.getKey());
            for (StringInteger postagFreq : (ArrayList)e.getValue()) {
                lexiconPW.print("\t" + postagFreq.string() + " " + postagFreq.integer());
            }
            lexiconPW.println();
        }
        grammarPW.close();
        lexiconPW.close();
    }

    public static void probGrammarForOneSentenceNew(File completeGrammarFile, String[] sentencePosWords, File grammarOut, File lexiconOut, char lexPosSeparationChar) {
        int freq;
        HashSet<String> sentencePosWordsSet = new HashSet<String>();
        String[] stringArray = sentencePosWords;
        int n = sentencePosWords.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            sentencePosWordsSet.add(w);
            ++n2;
        }
        PrintWriter grammarPW = FileUtil.getPrintWriter(grammarOut);
        PrintWriter lexiconPW = FileUtil.getPrintWriter(lexiconOut);
        Hashtable<String, ArrayList<StringInteger>> lexiconPostagsFreq = new Hashtable<String, ArrayList<StringInteger>>();
        Scanner scan = FileUtil.getScanner(completeGrammarFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            if (line.indexOf(34) == -1) {
                grammarPW.println(line);
                continue;
            }
            String[] lineSplit = line.split("\t");
            freq = Integer.parseInt(lineSplit[0]);
            String rule = lineSplit[1];
            String[] ruleSymbols = rule.split("\\s+");
            if (ruleSymbols.length == 2) {
                String pos_word = ruleSymbols[1].replaceAll("\"", "");
                if (!sentencePosWordsSet.contains(pos_word)) continue;
                String pos = ruleSymbols[0];
                StringInteger posFreq = new StringInteger(pos, 1);
                ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(pos_word, posFreq, lexiconPostagsFreq);
                continue;
            }
            boolean allLexicalWordsAreInTheSentence = true;
            ArrayList<String> lexicalRules = new ArrayList<String>();
            int i = 1;
            while (i < ruleSymbols.length) {
                String nodeRHS = ruleSymbols[i];
                if (nodeRHS.indexOf(34) != -1) {
                    String pos_word = nodeRHS.replaceAll("\"", "");
                    if (!sentencePosWordsSet.contains(pos_word)) {
                        allLexicalWordsAreInTheSentence = false;
                        break;
                    }
                    lexicalRules.add(pos_word);
                }
                ++i;
            }
            if (!allLexicalWordsAreInTheSentence) continue;
            rule = rule.replaceAll("\"", "");
            grammarPW.println(String.valueOf(freq) + "\t" + rule);
            for (String posWord : lexicalRules) {
                StringInteger posWordFreq = new StringInteger(posWord, 1);
                ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(posWord, posWordFreq, lexiconPostagsFreq);
            }
        }
        scan.close();
        String[] stringArray2 = sentencePosWords;
        freq = sentencePosWords.length;
        int n3 = 0;
        while (n3 < freq) {
            String posWord = stringArray2[n3];
            String pos = posWord.substring(0, posWord.indexOf(lexPosSeparationChar));
            StringInteger posFreq = new StringInteger(pos, 1);
            ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(posWord, posFreq, lexiconPostagsFreq);
            ++n3;
        }
        for (Map.Entry e : lexiconPostagsFreq.entrySet()) {
            lexiconPW.print((String)e.getKey());
            for (StringInteger postagFreq : (ArrayList)e.getValue()) {
                lexiconPW.print("\t" + postagFreq.string() + " " + postagFreq.integer());
            }
            lexiconPW.println();
        }
        grammarPW.close();
        lexiconPW.close();
    }

    public static void probGrammarForAllSentencesSelective(File completeGrammarFile, HashSet<String> sentencePosWordsSet, File grammarOut, File lexiconOut, char lexPosSeparationChar) {
        PrintWriter grammarPW = FileUtil.getPrintWriter(grammarOut);
        PrintWriter lexiconPW = FileUtil.getPrintWriter(lexiconOut);
        Hashtable<String, ArrayList<StringInteger>> lexiconPostagsFreq = new Hashtable<String, ArrayList<StringInteger>>();
        Scanner scan = FileUtil.getScanner(completeGrammarFile);
        while (scan.hasNextLine()) {
            String string = scan.nextLine();
            if (string.equals("")) continue;
            if (string.indexOf(34) == -1) {
                grammarPW.println(string);
                continue;
            }
            String[] lineSplit = string.split("\t");
            int freq = Integer.parseInt(lineSplit[0]);
            String rule = lineSplit[1];
            String[] ruleSymbols = rule.split("\\s+");
            if (ruleSymbols.length == 2) {
                String word = ruleSymbols[1].replaceAll("\"", "");
                if (!sentencePosWordsSet.contains(word)) continue;
                String pos = ruleSymbols[0];
                StringInteger posFreq = new StringInteger(pos, freq);
                ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(word, posFreq, lexiconPostagsFreq);
                continue;
            }
            boolean allLexicalWordsAreInTheSentence = true;
            ArrayList<String[]> lexicalRules = new ArrayList<String[]>();
            int i = 1;
            while (i < ruleSymbols.length) {
                String nodeRHS = ruleSymbols[i];
                if (nodeRHS.indexOf(34) != -1) {
                    String pos_word = nodeRHS.replaceAll("\"", "");
                    if (!sentencePosWordsSet.contains(pos_word)) {
                        allLexicalWordsAreInTheSentence = false;
                        break;
                    }
                    lexicalRules.add(new String[]{pos_word, pos_word});
                }
                ++i;
            }
            if (!allLexicalWordsAreInTheSentence) continue;
            rule = rule.replaceAll("\"", "");
            grammarPW.println(String.valueOf(freq) + "\t" + rule);
            for (String[] posWord : lexicalRules) {
                StringInteger posWordFreq = new StringInteger(posWord[1], 1);
                ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(posWord[0], posWordFreq, lexiconPostagsFreq);
            }
        }
        for (String string : sentencePosWordsSet) {
            String pos = string.substring(0, string.indexOf(lexPosSeparationChar));
            StringInteger posFreq = new StringInteger(pos, 1);
            ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(string, posFreq, lexiconPostagsFreq);
        }
        for (Map.Entry entry : lexiconPostagsFreq.entrySet()) {
            lexiconPW.print((String)entry.getKey());
            for (StringInteger postagFreq : (ArrayList)entry.getValue()) {
                lexiconPW.print("\t" + postagFreq.string() + " " + postagFreq.integer());
            }
            lexiconPW.println();
        }
        grammarPW.close();
        lexiconPW.close();
    }

    public static void probGrammarForAllSentences(File completeGrammarFile, HashSet<String> sentencePosWordsSet, File grammarOut, File lexiconOut, char lexPosSeparationChar) {
        PrintWriter grammarPW = FileUtil.getPrintWriter(grammarOut);
        PrintWriter lexiconPW = FileUtil.getPrintWriter(lexiconOut);
        Hashtable<String, ArrayList<StringInteger>> lexiconPostagsFreq = new Hashtable<String, ArrayList<StringInteger>>();
        Scanner scan = FileUtil.getScanner(completeGrammarFile);
        while (scan.hasNextLine()) {
            String string = scan.nextLine();
            if (string.equals("")) continue;
            if (string.indexOf(34) == -1) {
                grammarPW.println(string);
                continue;
            }
            String[] lineSplit = string.split("\t");
            int freq = Integer.parseInt(lineSplit[0]);
            String rule = lineSplit[1];
            String[] ruleSymbols = rule.split("\\s+");
            if (ruleSymbols.length == 2) {
                String word = ruleSymbols[1].replaceAll("\"", "");
                String pos = ruleSymbols[0];
                StringInteger posFreq = new StringInteger(pos, freq);
                ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(word, posFreq, lexiconPostagsFreq);
                continue;
            }
            int i = 1;
            while (i < ruleSymbols.length) {
                String nodeRHS = ruleSymbols[i];
                if (nodeRHS.indexOf(34) != -1) {
                    String pos_word = nodeRHS.replaceAll("\"", "");
                    StringInteger posWordFreq = new StringInteger(pos_word, 1);
                    ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(pos_word, posWordFreq, lexiconPostagsFreq);
                }
                ++i;
            }
            rule = rule.replaceAll("\"", "");
            grammarPW.println(String.valueOf(freq) + "\t" + rule);
        }
        for (String string : sentencePosWordsSet) {
            String pos = string.substring(0, string.indexOf(lexPosSeparationChar));
            StringInteger posFreq = new StringInteger(pos, 1);
            ConvertGrammarInBitParFormat.addLexPosFreqIfNotPresent(string, posFreq, lexiconPostagsFreq);
        }
        for (Map.Entry entry : lexiconPostagsFreq.entrySet()) {
            lexiconPW.print((String)entry.getKey());
            for (StringInteger postagFreq : (ArrayList)entry.getValue()) {
                lexiconPW.print("\t" + postagFreq.string() + " " + postagFreq.integer());
            }
            lexiconPW.println();
        }
        grammarPW.close();
        lexiconPW.close();
    }

    public static void add(String key, String valueItem, Hashtable<String, ArrayList<String>> table) {
        ArrayList<String> value = table.get(key);
        if (value == null) {
            value = new ArrayList();
            table.put(key, value);
        }
        value.add(valueItem);
    }

    public static void addLexPosFreq(String key, StringInteger valueItem, Hashtable<String, ArrayList<StringInteger>> table) {
        ArrayList<StringInteger> value = table.get(key);
        if (value == null) {
            value = new ArrayList();
            table.put(key, value);
        }
        value.add(valueItem);
    }

    public static void addLexPosFreqIfNotPresent(String key, StringInteger valueItem, Hashtable<String, ArrayList<StringInteger>> table) {
        ArrayList<StringInteger> value = table.get(key);
        if (value == null) {
            value = new ArrayList();
            value.add(valueItem);
            table.put(key, value);
            return;
        }
        String pos = valueItem.string();
        for (StringInteger vi : value) {
            if (!vi.string().equals(pos)) continue;
            int freq = valueItem.integer();
            if (freq > vi.integer()) {
                vi.setInteger(freq);
            }
            return;
        }
        value.add(valueItem);
    }

    public static void main(String[] args) {
    }
}

