/*
 * Decompiled with CFR 0.152.
 */
package tsg.parseEval;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import settings.Parameters;
import tsg.parseEval.EvalF;
import util.FileUtil;
import util.PrintProgress;

public class EvalB {
    public EvalB(File goldFile, File parsedFile, File outputFile, boolean labeled) {
        String resultFolder = String.valueOf(Parameters.resultsPath) + "TSG/";
        String evalbApp = "/Users/fsangati/Work/SOFTWARE/EVALB/evalb";
        String evalbArgs = "-p " + resultFolder + "collins" + EvalF.MAX_SENTENCE_LENGTH;
        evalbArgs = String.valueOf(evalbArgs) + (labeled ? ".prm" : ".UL.prm");
        try {
            Process p = Runtime.getRuntime().exec(String.valueOf(evalbApp) + " " + evalbArgs + " " + goldFile + " " + parsedFile);
            EvalB.redirectOutput(p, outputFile, false);
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    private static void redirectOutput(Process p, File outFile, boolean printProgress) {
        try {
            String s = null;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            PrintWriter pw = FileUtil.getPrintWriter(outFile);
            int sentenceIndex = 1;
            PrintProgress.start("Running evalB, outputted line:");
            while ((s = stdInput.readLine()) != null) {
                pw.println(s);
                if (!printProgress || s.length() == 0 || s.startsWith("vitprob")) continue;
                PrintProgress.next();
                ++sentenceIndex;
            }
            PrintProgress.end();
            p.getInputStream().close();
            p.getOutputStream().close();
            p.getErrorStream().close();
            pw.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
    }

    public static void main(String[] args) {
        String basePath = "/scratch/fsangati/RESULTS/TSG/DOP_SD_Reranker/";
        File gold = new File(String.valueOf(basePath) + "wsj-22_gold.mrg");
        File test = new File(String.valueOf(basePath) + "wsj-22_reranked_5best_PQ.mrg");
        File evalF = new File(String.valueOf(basePath) + "wsj-22_reranked_5best_PQ.evalB");
        new EvalB(gold, test, evalF, true);
    }
}

