/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import settings.Parameters;
import tsg.DistributeTreeBankInDepthFiles;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelStructure;
import tsg.kernels.AllOrderedNodeSubSet;
import tsg.kernels.CommonSubBranch;
import tsg.kernels.CommonSubBranchMUBFreq;
import tsg.kernels.CommonSubtreesMUBFreqNew;
import tsg.kernels.RetrieveCorrectFreq;
import util.FileUtil;

public class FragmentSeeker {
    public static void reportLog(String log) {
        System.out.println(log);
        Parameters.appendInLogFile(log);
    }

    public static void main(String[] args) throws Exception {
        Object cs;
        File inputFile;
        String exactFrequenciesOption = "-exactFrequencies";
        String partialFragmentsOption = "-partialFragments";
        String maxCombinationOption = "-maxCombination:";
        String maxMappingsOption = "-maxMappings:";
        String outputDir = null;
        boolean exactFrequencies = false;
        boolean partialFragments = false;
        CommonSubBranch.maxCombDaughters = 1000;
        AllOrderedNodeSubSet.maxComb = 1000;
        String usage = "USAGE: java [-Xmx1G] [-Xmx500M] -jar FragmentSeeker.jar [-partialFragments] [-maxCombination:1000] [-maxMappings:1000] [-exactFrequencies] inputFile";
        AllOrderedNodeSubSet.maxComb = 1000;
        CommonSubBranch.maxCombDaughters = 1000;
        if (args.length == 0 || args.length > 7) {
            System.err.println("Incorrect number of arguments");
            System.err.println(usage);
            System.exit(-1);
        }
        if (args.length > 1) {
            int i = 0;
            while (i < args.length - 1) {
                String option = args[i];
                if (option.equals(exactFrequenciesOption)) {
                    exactFrequencies = true;
                } else if (option.equals(partialFragmentsOption)) {
                    partialFragments = true;
                } else if (option.startsWith(maxCombinationOption)) {
                    CommonSubBranch.maxCombDaughters = Integer.parseInt(option.substring(option.indexOf(58) + 1));
                } else if (option.startsWith(maxMappingsOption)) {
                    AllOrderedNodeSubSet.maxComb = Integer.parseInt(option.substring(option.indexOf(58) + 1));
                } else {
                    System.err.println("Not a valid option: " + option);
                    System.err.println(usage);
                    System.exit(-1);
                }
                ++i;
            }
        }
        if (!(inputFile = new File(args[args.length - 1])).exists() || !inputFile.canRead()) {
            System.err.println("Inpur file doesn't exist or not accessible: " + args[args.length - 1]);
            System.exit(-1);
        }
        String inputFileAbsolutePath = null;
        try {
            inputFileAbsolutePath = inputFile.getCanonicalPath();
            outputDir = inputFile.getCanonicalFile().getParentFile().getCanonicalPath();
        }
        catch (IOException e) {
            System.err.println("Inpur file doesn't exist or not accessible: " + args[args.length - 1]);
            System.exit(-1);
        }
        outputDir = String.valueOf(outputDir) + "/FragmentSeeker_" + FileUtil.dataFolder() + "/";
        new File(outputDir).mkdir();
        Parameters.logFile = new File(String.valueOf(outputDir) + "FS.log");
        FragmentSeeker.reportLog("FragmentSeeker being run with arguments: " + Arrays.toString(args));
        FragmentSeeker.reportLog(String.valueOf(maxCombinationOption) + ":" + CommonSubBranch.maxCombDaughters);
        FragmentSeeker.reportLog(String.valueOf(maxMappingsOption) + ":" + AllOrderedNodeSubSet.maxComb);
        ArrayList<TSNodeLabelStructure> treebankStructure = null;
        ArrayList<TSNodeLabel> treebank = null;
        try {
            treebankStructure = TSNodeLabelStructure.readTreebank(inputFile);
            treebank = TSNodeLabel.getTreebank(inputFile);
        }
        catch (Exception e) {
            PrintWriter logPW = FileUtil.getPrintWriter(Parameters.logFile);
            e.printStackTrace(logPW);
            logPW.close();
            System.err.println("Something wrong happened while reading the treebank in file: " + inputFileAbsolutePath + "\nCheck the format and try again. More info in log file.");
            System.exit(-1);
        }
        FragmentSeeker.reportLog("Treebank size: " + treebankStructure.size());
        if (treebankStructure.size() < 2) {
            System.err.println("The treebank should have at least 2 structures.");
            System.exit(-1);
        }
        int maxDepth = TSNodeLabelStructure.maxDepthTreebank(treebankStructure);
        FragmentSeeker.reportLog("Max depth: " + maxDepth);
        if (partialFragments) {
            CommonSubBranchMUBFreq.maxDepth = maxDepth;
            cs = new CommonSubBranchMUBFreq(treebankStructure);
            ((CommonSubBranchMUBFreq)cs).extractFromTreebank();
            System.out.println("Finished Extracting Partial Fragmetns.");
            File fragmentApproxFreqFile = new File(String.valueOf(outputDir) + "partialfragments_approxFreq.txt");
            ((CommonSubBranchMUBFreq)cs).printFragmentsToFile(fragmentApproxFreqFile);
            FragmentSeeker.reportLog("Partial Fragments with their approximate Frequencies written in:\n\t" + fragmentApproxFreqFile);
            String fragmentsDepthDirApprox = String.valueOf(outputDir) + "DepthPartialFragments_ApproxFreq/";
            new File(fragmentsDepthDirApprox).mkdir();
            String baseFileDepthPrefix = String.valueOf(fragmentsDepthDirApprox) + "PartialFragments_depth";
            new DistributeTreeBankInDepthFiles(fragmentApproxFreqFile, baseFileDepthPrefix);
            FragmentSeeker.reportLog("Partial Fragments with their approximate Frequencies and distributed according to their depths written in:\n\t" + fragmentsDepthDirApprox);
            if (exactFrequencies) {
                File fragmentExactFreqFile = new File(String.valueOf(outputDir) + "partialfragments_exactFreq.txt");
                RetrieveCorrectFreq.retriveCorrectFreq(treebank, fragmentApproxFreqFile, fragmentExactFreqFile, true);
                FragmentSeeker.reportLog("Partial Fragments with their exact Frequencies written in:\n\t" + fragmentExactFreqFile);
                String fragmentsDepthDirExact = String.valueOf(outputDir) + "DepthPartialFragments_ExactFreq/";
                new File(fragmentsDepthDirExact).mkdir();
                baseFileDepthPrefix = String.valueOf(fragmentsDepthDirExact) + "PartialFragments_depth";
                new DistributeTreeBankInDepthFiles(fragmentExactFreqFile, baseFileDepthPrefix);
                FragmentSeeker.reportLog("Partial Fragments with their exact Frequencies and distributed according to their depths written in:\n\t" + fragmentsDepthDirApprox);
            }
        } else {
            CommonSubtreesMUBFreqNew.maxDepth = maxDepth;
            cs = new CommonSubtreesMUBFreqNew(treebankStructure);
            ((CommonSubtreesMUBFreqNew)cs).extractFromTreebank();
            System.out.println("Finished Extracting Fragmetns.");
            File fragmentApproxFreqFile = new File(String.valueOf(outputDir) + "fragments_approxFreq.txt");
            ((CommonSubtreesMUBFreqNew)cs).printFragmentsToFile(fragmentApproxFreqFile);
            FragmentSeeker.reportLog("Fragments with their approximate Frequencies written in:\n\t" + fragmentApproxFreqFile);
            String fragmentsDepthDirApprox = String.valueOf(outputDir) + "DepthFragments_ApproxFreq/";
            new File(fragmentsDepthDirApprox).mkdir();
            String baseFileDepthPrefix = String.valueOf(fragmentsDepthDirApprox) + "Fragments_depth";
            new DistributeTreeBankInDepthFiles(fragmentApproxFreqFile, baseFileDepthPrefix);
            FragmentSeeker.reportLog("Fragments with their approximate Frequencies and distributed according to their depths written in:\n\t" + fragmentsDepthDirApprox);
            if (exactFrequencies) {
                File fragmentExactFreqFile = new File(String.valueOf(outputDir) + "fragments_exactFreq.txt");
                RetrieveCorrectFreq.retriveCorrectFreq(treebank, fragmentApproxFreqFile, fragmentExactFreqFile, false);
                FragmentSeeker.reportLog("Partial Fragments with their exact Frequencies written in:\n\t" + fragmentExactFreqFile);
                String fragmentsDepthDirExact = String.valueOf(outputDir) + "DepthFragments_ExactFreq/";
                new File(fragmentsDepthDirExact).mkdir();
                baseFileDepthPrefix = String.valueOf(fragmentsDepthDirExact) + "PartialFragments_depth";
                new DistributeTreeBankInDepthFiles(fragmentExactFreqFile, baseFileDepthPrefix);
                FragmentSeeker.reportLog("Fragments with their exact Frequencies and distributed according to their depths written in:\n\t" + fragmentsDepthDirApprox);
            }
        }
    }
}

