/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.ListIterator;
import kernels.NodeSetCollector;
import kernels.NodeSetCollectorStandard;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import tsg.corpora.Wsj;
import tsg.kernels.CommonSubtrees;
import util.FileUtil;
import util.PrintProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonSubtreesStandard
extends CommonSubtrees {
    public static int learningCurvePoints = 50;
    HashSet<TSNodeLabel> fragmentBank;
    int[] learningCurveDepth = new int[30];

    public CommonSubtreesStandard(ArrayList<TSNodeLabelStructure> treebank) {
        super(treebank);
        this.fragmentBank = new HashSet();
        NodeSetCollectorStandard collector = new NodeSetCollectorStandard();
        int t1Index = -1;
        PrintProgress.start("Extracting fragment from sentence :");
        for (TSNodeLabelStructure t1 : treebank) {
            PrintProgress.next();
            ListIterator<TSNodeLabelStructure> i2 = treebank.listIterator(++t1Index + 1);
            while (i2.hasNext()) {
                TSNodeLabelStructure t2 = i2.next();
                NodeSetCollector[][] CST = CommonSubtreesStandard.getCST(t1, t2, (NodeSetCollector)collector);
                this.extractSubTrees(CST, t1);
            }
        }
        PrintProgress.end();
    }

    public CommonSubtreesStandard(ArrayList<TSNodeLabelStructure> treebank, int i1, int i2) {
        super(treebank);
        TSNodeLabelStructure t1 = treebank.get(i1);
        TSNodeLabelStructure t2 = treebank.get(i2);
        System.out.println(t1.structure()[0]);
        System.out.println(t2.structure()[0]);
    }

    public CommonSubtreesStandard(ArrayList<TSNodeLabelStructure> treebank, File traceLearningCurveFile) {
        super(treebank);
        int treebankSize = treebank.size();
        int learningCurveEvery = treebankSize * (treebankSize + 1) / 2 / learningCurvePoints;
        System.out.println("Printing learning curve every: " + learningCurveEvery);
        PrintWriter pw = FileUtil.getPrintWriter(traceLearningCurveFile);
        this.fragmentBank = new HashSet();
        NodeSetCollectorStandard collector = new NodeSetCollectorStandard();
        int t1Index = -1;
        int learningCounter = 0;
        PrintProgress.start("Extracting fragment from sentence :");
        for (TSNodeLabelStructure t1 : treebank) {
            PrintProgress.next();
            ListIterator<TSNodeLabelStructure> i2 = treebank.listIterator(++t1Index + 1);
            while (i2.hasNext()) {
                TSNodeLabelStructure t2 = i2.next();
                NodeSetCollector[][] CST = CommonSubtreesStandard.getCST(t1, t2, (NodeSetCollector)collector);
                this.extractSubTrees(CST, t1, true);
                if (++learningCounter % learningCurveEvery != 0) continue;
                this.storeLearningData(pw, learningCounter);
            }
            this.storeLearningData(pw, learningCounter);
        }
        PrintProgress.end();
        pw.close();
    }

    private void storeLearningData(PrintWriter pw, int learningCounter) {
        pw.print(String.valueOf(learningCounter) + "\t");
        int[] nArray = this.learningCurveDepth;
        int n = this.learningCurveDepth.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            pw.print(String.valueOf(i) + "\t");
            ++n2;
        }
        pw.println();
        this.learningCurveDepth = new int[30];
    }

    private void extractSubTrees(NodeSetCollector[][] CPG, TSNodeLabelStructure s) {
        int nodeIndex = -1;
        NodeSetCollector[][] nodeSetCollectorArray = CPG;
        int n = CPG.length;
        int n2 = 0;
        while (n2 < n) {
            NodeSetCollector[] nodeCollectors = nodeSetCollectorArray[n2];
            ++nodeIndex;
            NodeSetCollectorStandard nodeSet = new NodeSetCollectorStandard();
            NodeSetCollector[] nodeSetCollectorArray2 = nodeCollectors;
            int n3 = nodeCollectors.length;
            int n4 = 0;
            while (n4 < n3) {
                NodeSetCollector coll = nodeSetCollectorArray2[n4];
                nodeSet.addAll(coll);
                ++n4;
            }
            nodeSet.removeUniqueSingleton();
            for (BitSet bs : nodeSet.bitSetArray) {
                this.fragmentBank.add(s.structure[nodeIndex].getSubTree(bs));
            }
            ++n2;
        }
    }

    private void extractSubTrees(NodeSetCollector[][] CPG, TSNodeLabelStructure s, boolean traceLearningCurve) {
        int nodeIndex = -1;
        NodeSetCollector[][] nodeSetCollectorArray = CPG;
        int n = CPG.length;
        int n2 = 0;
        while (n2 < n) {
            NodeSetCollector[] nodeCollectors = nodeSetCollectorArray[n2];
            TSNodeLabelIndex node = s.structure[++nodeIndex];
            NodeSetCollectorStandard nodeSet = new NodeSetCollectorStandard();
            NodeSetCollector[] nodeSetCollectorArray2 = nodeCollectors;
            int n3 = nodeCollectors.length;
            int n4 = 0;
            while (n4 < n3) {
                NodeSetCollector coll = nodeSetCollectorArray2[n4];
                nodeSet.addAll(coll);
                ++n4;
            }
            nodeSet.removeUniqueSingleton();
            for (BitSet bs : nodeSet.bitSetArray) {
                TSNodeLabel fragment = node.getSubTree(bs);
                if (!this.fragmentBank.add(fragment)) continue;
                int n5 = fragment.maxDepth();
                this.learningCurveDepth[n5] = this.learningCurveDepth[n5] + 1;
            }
            ++n2;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        for (TSNodeLabel t : this.fragmentBank) {
            sb.append(String.valueOf(t.toString()) + "\n");
        }
        return sb.toString();
    }

    public void printFragmentsToFile(File outpuFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outpuFile);
        for (TSNodeLabel t : this.fragmentBank) {
            pw.println(t.toString(false, true));
        }
        pw.close();
    }

    public String reportFragmentDepth() {
        int[] depthCount = new int[50];
        for (TSNodeLabel t : this.fragmentBank) {
            int n = t.maxDepth();
            depthCount[n] = depthCount[n] + 1;
        }
        StringBuilder sb = new StringBuilder("");
        int d = 0;
        int[] nArray = depthCount;
        int n = depthCount.length;
        int n2 = 0;
        while (n2 < n) {
            int dSize = nArray[n2];
            if (dSize != 0) {
                sb.append("Depth " + d + ":\t" + dSize + "\n");
            }
            ++d;
            ++n2;
        }
        return sb.toString();
    }

    public static void main1(String[] args) throws Exception {
        File inputFile = new File("tmp/FewParseTrees.txt");
        ArrayList<TSNodeLabelStructure> treebank = TSNodeLabelStructure.readTreebank(inputFile, FileUtil.defaultEncoding, 10000);
        System.out.println("Treebank size: " + treebank.size());
        CommonSubtreesStandard cs = new CommonSubtreesStandard(treebank);
        System.out.println(cs.reportFragmentDepth());
        System.out.println(cs.fragmentBank.size());
    }

    public static void mainCompare(String[] args) throws Exception {
        File inputFile = new File(String.valueOf(Wsj.WsjOriginalCleaned) + "wsj-02-21_noDoubles.mrg");
        ArrayList<TSNodeLabelStructure> treebank = TSNodeLabelStructure.readTreebank(inputFile, FileUtil.defaultEncoding, 10000);
        System.out.println("Treebank size: " + treebank.size());
        CommonSubtreesStandard cs = new CommonSubtreesStandard(treebank, 287, 7900);
    }

    public static void main(String[] args) throws Exception {
        File inputFile = new File(String.valueOf(Wsj.WsjOriginalCleaned) + "wsj-02-21_noDoubles.mrg");
        String outputFolder = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/";
        new File(outputFolder).mkdirs();
        File learningCurveFile = new File(String.valueOf(outputFolder) + "learningFragments_20.txt");
        ArrayList<TSNodeLabelStructure> treebank = TSNodeLabelStructure.readTreebank(inputFile, FileUtil.defaultEncoding, 20);
        System.out.println("Treebank size: " + treebank.size());
        CommonSubtreesStandard cs = new CommonSubtreesStandard(treebank, learningCurveFile);
        String fragmentDepthReport = cs.reportFragmentDepth();
        FileUtil.append(fragmentDepthReport, new File(String.valueOf(outputFolder) + "fragmentDepthReport_20.txt"));
        System.out.println(fragmentDepthReport);
        cs.printFragmentsToFile(new File(String.valueOf(outputFolder) + "fragments_20.txt"));
    }
}

