/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import kernels.NodeSetCollector;
import kernels.NodeSetCollectorMUB;
import kernels.NodeSetCollectorSimple;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import tsg.corpora.Wsj;
import tsg.kernels.AllOrderedNodeSubSet;
import tsg.kernels.CommonSubBranch;
import util.FileUtil;
import util.PrintProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonSubBranchMUBFreq
extends CommonSubBranch {
    public static int maxDepth = 50;
    public static int learningCurvePoints = 50;
    Hashtable<TSNodeLabel, int[]> fragmentBank = new Hashtable();
    PrintWriter pw_C0;
    PrintWriter pw_C1;
    PrintWriter pw_Tot;

    public CommonSubBranchMUBFreq(ArrayList<TSNodeLabelStructure> treebank) {
        super(treebank);
    }

    public void printMaxCombinationPairs(int treshold, File outputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        ListIterator i1 = this.treebank.listIterator();
        while (i1.hasNext()) {
            int t1Index = i1.nextIndex();
            TSNodeLabelStructure t1 = (TSNodeLabelStructure)i1.next();
            PrintProgress.next();
            ListIterator i2 = this.treebank.listIterator(t1Index + 1);
            while (i2.hasNext()) {
                int t2Index = i2.nextIndex();
                TSNodeLabelStructure t2 = (TSNodeLabelStructure)i2.next();
                int maxComb = CommonSubBranchMUBFreq.getMaxCombinationDaughtersMatch(t1, t2);
                if (maxComb <= treshold) continue;
                String lineReport = String.valueOf(t1Index) + "\t" + t2Index + "\t" + maxComb;
                System.out.println("\n" + lineReport);
                pw.println(lineReport);
            }
            pw.flush();
        }
        PrintProgress.end();
        pw.close();
    }

    public void extractFromTreebank() {
        NodeSetCollectorMUB collector = new NodeSetCollectorMUB();
        int t1Index = -1;
        PrintProgress.start("Extracting fragment from sentence :");
        for (TSNodeLabelStructure t1 : this.treebank) {
            PrintProgress.next();
            NodeSetCollectorSimple intermediateCollector = new NodeSetCollectorSimple();
            ListIterator i2 = this.treebank.listIterator(++t1Index + 1);
            while (i2.hasNext()) {
                TSNodeLabelStructure t2 = (TSNodeLabelStructure)i2.next();
                NodeSetCollector[][] CST = CommonSubBranchMUBFreq.getCST(t1, t2, (NodeSetCollector)collector);
                this.extractSubTreesIntermediate(CST, (NodeSetCollector)intermediateCollector);
            }
            this.extractSubTreesInTable(intermediateCollector, t1);
        }
        PrintProgress.end();
    }

    public void extractFromTreebankAndLearningCurve(File traceLearningCurveFileC0, File traceLearningCurveFileC1, File traceLearningCurveFileTot) {
        this.pw_C0 = FileUtil.getPrintWriter(traceLearningCurveFileC0);
        this.pw_C1 = FileUtil.getPrintWriter(traceLearningCurveFileC1);
        this.pw_Tot = FileUtil.getPrintWriter(traceLearningCurveFileTot);
        this.fragmentBank = new Hashtable();
        NodeSetCollectorMUB collectorType = new NodeSetCollectorMUB();
        int t1IndexOneBased = 1;
        PrintProgress.start("Extracting fragment from sentence :");
        for (TSNodeLabelStructure t1 : this.treebank) {
            PrintProgress.next();
            NodeSetCollectorSimple intermediateCollector = new NodeSetCollectorSimple();
            ListIterator i2 = this.treebank.listIterator(t1IndexOneBased);
            while (i2.hasNext()) {
                TSNodeLabelStructure t2 = (TSNodeLabelStructure)i2.next();
                NodeSetCollector[][] CST = CommonSubBranchMUBFreq.getCST(t1, t2, (NodeSetCollector)collectorType);
                this.extractSubTreesIntermediate(CST, (NodeSetCollector)intermediateCollector);
            }
            this.extractSubTreesInTableAndTraceCurve(intermediateCollector, t1, t1IndexOneBased);
            ++t1IndexOneBased;
        }
        PrintProgress.end();
        this.pw_C0.close();
        this.pw_C1.close();
        this.pw_Tot.close();
    }

    private void extractSubTreesIntermediate(NodeSetCollector[][] CPG, NodeSetCollector intermediateCollector) {
        int nodeIndex = -1;
        NodeSetCollectorMUB finalNodeSet = new NodeSetCollectorMUB();
        NodeSetCollector[][] nodeSetCollectorArray = CPG;
        int n = CPG.length;
        int n2 = 0;
        while (n2 < n) {
            NodeSetCollector[] wordCollectors = nodeSetCollectorArray[n2];
            ++nodeIndex;
            NodeSetCollector[] nodeSetCollectorArray2 = wordCollectors;
            int n3 = wordCollectors.length;
            int n4 = 0;
            while (n4 < n3) {
                NodeSetCollector coll = nodeSetCollectorArray2[n4];
                finalNodeSet.addAll(coll);
                ++n4;
            }
            ++n2;
        }
        for (BitSet bs : finalNodeSet.bitSetSet) {
            if (bs.cardinality() == 1) continue;
            intermediateCollector.add(bs);
        }
    }

    private void extractSubTreesInTableAndTraceCurve(NodeSetCollectorSimple intermediateCollector, TSNodeLabelStructure s, int treeCounter) {
        int[] learningCurveDepth_C0 = new int[maxDepth];
        int[] learningCurveDepth_C1 = new int[maxDepth];
        int[] learningCurveDepth_Tot = new int[maxDepth];
        for (BitSet bs : intermediateCollector.bitSetSet) {
            int depth;
            TSNodeLabelIndex rootNode = s.structure[bs.nextSetBit(0)];
            TSNodeLabel fragment = rootNode.getSubBranch(bs);
            int freq = this.add(fragment);
            int n = depth = fragment.maxDepth();
            learningCurveDepth_Tot[n] = learningCurveDepth_Tot[n] + 1;
            if (freq == 1) {
                int n2 = depth;
                learningCurveDepth_C0[n2] = learningCurveDepth_C0[n2] + 1;
                continue;
            }
            if (freq != 2) continue;
            int n3 = depth;
            learningCurveDepth_C1[n3] = learningCurveDepth_C1[n3] + 1;
        }
        this.pw_C0.print(String.valueOf(treeCounter) + "\t");
        this.pw_C1.print(String.valueOf(treeCounter) + "\t");
        this.pw_Tot.print(String.valueOf(treeCounter) + "\t");
        int i = 0;
        while (i < maxDepth) {
            int C0i = learningCurveDepth_C0[i];
            int C1i = learningCurveDepth_C1[i];
            int CTi = learningCurveDepth_Tot[i];
            this.pw_C0.print(C0i == 0 ? Integer.valueOf(0) : String.valueOf((float)C0i / (float)CTi) + "\t");
            this.pw_C1.print(C1i == 0 ? Integer.valueOf(0) : String.valueOf((float)C1i / (float)CTi) + "\t");
            this.pw_Tot.print(String.valueOf(CTi) + "\t");
            ++i;
        }
        this.pw_C0.println();
        this.pw_C1.println();
        this.pw_Tot.println();
        this.pw_C0.flush();
        this.pw_C1.flush();
        this.pw_Tot.flush();
    }

    private void extractSubTreesInTable(NodeSetCollectorSimple intermediateCollector, TSNodeLabelStructure s) {
        for (BitSet bs : intermediateCollector.bitSetSet) {
            TSNodeLabelIndex rootNode = s.structure[bs.nextSetBit(0)];
            TSNodeLabel fragment = rootNode.getSubBranch(bs);
            this.add(fragment);
        }
    }

    private int add(TSNodeLabel fragment) {
        int[] freq = this.fragmentBank.get(fragment);
        if (freq == null) {
            this.fragmentBank.put(fragment, new int[]{1});
            return 1;
        }
        freq[0] = freq[0] + 1;
        return freq[0];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        for (Map.Entry<TSNodeLabel, int[]> entry : this.fragmentBank.entrySet()) {
            sb.append(String.valueOf(entry.getKey().toString(false, true)) + "\t" + entry.getValue()[0] + "\n");
        }
        return sb.toString();
    }

    public void printFragmentsToFile(File outpuFile) {
        PrintWriter pw = FileUtil.getPrintWriter(outpuFile);
        for (Map.Entry<TSNodeLabel, int[]> entry : this.fragmentBank.entrySet()) {
            pw.println(String.valueOf(entry.getKey().toString(false, true)) + "\t" + entry.getValue()[0]);
        }
        pw.close();
    }

    public String reportFragmentDepth() {
        int[] depthCountTypes = new int[50];
        int[] depthCountTypesFG1 = new int[50];
        long[] depthCountTokens = new long[50];
        for (Map.Entry<TSNodeLabel, int[]> entry : this.fragmentBank.entrySet()) {
            int depth = entry.getKey().maxDepth();
            int freq = entry.getValue()[0];
            int n = depth;
            depthCountTypes[n] = depthCountTypes[n] + 1;
            int n2 = depth;
            depthCountTokens[n2] = depthCountTokens[n2] + (long)freq;
            if (freq <= 1) continue;
            int n3 = depth;
            depthCountTypesFG1[n3] = depthCountTypesFG1[n3] + 1;
        }
        StringBuilder sb = new StringBuilder("");
        sb.append("Depth\t#types\t#tokens\t#types>1\n");
        int d = 0;
        while (d < 50) {
            int typesD = depthCountTypes[d];
            int typesDFG1 = depthCountTypesFG1[d];
            long tokensD = depthCountTokens[d];
            if (typesD != 0) {
                sb.append(String.valueOf(d) + "\t" + typesD + "\t" + tokensD + "\t" + typesDFG1 + "\n");
            }
            ++d;
        }
        return sb.toString();
    }

    public static void main1(String[] args) throws Exception {
        File inputFile = new File(String.valueOf(Wsj.WsjOriginalCleaned) + "wsj-02-21.mrg");
        String outputFolder = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/Wsj/KenelFragments/SemTagOn/subBranch/all/";
        File outputFile = new File(String.valueOf(outputFolder) + "maxCombFile_subBranch_all_new.txt");
        ArrayList<TSNodeLabelStructure> treebank = TSNodeLabelStructure.readTreebank(inputFile);
        CommonSubBranchMUBFreq cs = new CommonSubBranchMUBFreq(treebank);
        cs.printMaxCombinationPairs(1000, outputFile);
        System.out.println(cs.toString());
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Max Depth:" + maxDepth);
        File inputFile = new File(String.valueOf(Wsj.WsjOriginalCleaned) + "wsj-02-21.mrg");
        ArrayList<TSNodeLabelStructure> treebank = TSNodeLabelStructure.readTreebank(inputFile, FileUtil.defaultEncoding, Integer.MAX_VALUE);
        String outputFolder = String.valueOf(Parameters.resultsPath) + "TSG/TSGkernels/Wsj/KenelFragments/SemTagOn/subBranch/all/";
        new File(outputFolder).mkdirs();
        File fragmentDepthReportFile = new File(String.valueOf(outputFolder) + "fragmentDepthReport_subBranch_MUB_freq_all.txt");
        Parameters.logFile = new File(String.valueOf(outputFolder) + "logFile.log");
        FileUtil.cleanFile(Parameters.logFile);
        AllOrderedNodeSubSet.maxComb = 1000;
        Parameters.appendInLogFile("AllOrderedNodeSubSet.maxComb\t" + AllOrderedNodeSubSet.maxComb);
        CommonSubBranch.maxCombDaughters = 1000;
        Parameters.appendInLogFile("CommonSubBranch.maxCombDaughters\t" + CommonSubBranch.maxCombDaughters);
        System.out.println("Treebank size: " + treebank.size());
        CommonSubBranchMUBFreq cs = new CommonSubBranchMUBFreq(treebank);
        cs.extractFromTreebank();
        String fragmentDepthReport = cs.reportFragmentDepth();
        FileUtil.append(fragmentDepthReport, fragmentDepthReportFile);
        System.out.println(fragmentDepthReport);
        cs.printFragmentsToFile(new File(String.valueOf(outputFolder) + "fragments_subBranch_MUB_freq_all.txt"));
    }
}

