/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.util.ArrayList;
import kernels.NodeSetCollector;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import tsg.kernels.AllOrderedNodeSubSet;
import util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonSubBranch {
    public static int maxCombDaughters = 1000;
    ArrayList<TSNodeLabelStructure> treebank;

    public CommonSubBranch(ArrayList<TSNodeLabelStructure> treebank) {
        this.treebank = treebank;
    }

    protected static NodeSetCollector[][] getCST(TSNodeLabelStructure t1, TSNodeLabelStructure t2, NodeSetCollector collector) {
        NodeSetCollector[][] CST = new NodeSetCollector[t1.length()][t2.length()];
        int currentLength = t1.length();
        TSNodeLabelIndex[] tSNodeLabelIndexArray = t1.structure;
        int n = t1.structure.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabelIndex nodeA = tSNodeLabelIndexArray[n2];
            TSNodeLabelIndex[] tSNodeLabelIndexArray2 = t2.structure;
            int n3 = t2.structure.length;
            int n4 = 0;
            while (n4 < n3) {
                TSNodeLabelIndex nodeB = tSNodeLabelIndexArray2[n4];
                CommonSubBranch.getCST(nodeA, nodeB, CST, collector, currentLength);
                ++n4;
            }
            ++n2;
        }
        return CST;
    }

    protected static int getMaxCombinationDaughtersMatch(TSNodeLabelStructure t1, TSNodeLabelStructure t2) {
        int max = 0;
        TSNodeLabelIndex[] tSNodeLabelIndexArray = t1.structure;
        int n = t1.structure.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabelIndex nodeA = tSNodeLabelIndexArray[n2];
            TSNodeLabelIndex[] tSNodeLabelIndexArray2 = t2.structure;
            int n3 = t2.structure.length;
            int n4 = 0;
            while (n4 < n3) {
                int comb;
                TSNodeLabelIndex nodeB = tSNodeLabelIndexArray2[n4];
                if (nodeA.sameLabel(nodeB) && !nodeA.isLexical && !nodeB.isLexical && (comb = AllOrderedNodeSubSet.allDaughtersMatchSize(nodeA, nodeB)) > max) {
                    max = comb;
                }
                ++n4;
            }
            ++n2;
        }
        return max;
    }

    private static NodeSetCollector getCST(TSNodeLabelIndex nodeA, TSNodeLabelIndex nodeB, NodeSetCollector[][] CST, NodeSetCollector collector, int currentLength) {
        NodeSetCollector stored = CST[nodeA.index][nodeB.index];
        if (stored != null) {
            return stored;
        }
        NodeSetCollector nodeCollector = (NodeSetCollector)collector.clone();
        nodeCollector.setMaxLength(currentLength);
        if (nodeA.isLexical == nodeB.isLexical && nodeA.sameLabel(nodeB)) {
            ArrayList<ArrayList<Pair<TSNodeLabel>>> allDaughtersMatch;
            nodeCollector.addDefaultBitSet(nodeA.index);
            if (!nodeA.isLexical && (allDaughtersMatch = AllOrderedNodeSubSet.allDaughtersMatchBackupOnSimple(nodeA, nodeB)) != null) {
                int p = 0;
                for (ArrayList<Pair<TSNodeLabel>> pairList : allDaughtersMatch) {
                    int prole = pairList.size();
                    NodeSetCollector[] nodeCollDaughters = new NodeSetCollector[prole];
                    int[] nodeSetDaughtersLength = new int[prole];
                    int i = 0;
                    long totalComb = 1L;
                    for (Pair<TSNodeLabel> pair : pairList) {
                        int size;
                        NodeSetCollector collD;
                        TSNodeLabelIndex nodeADaughter = (TSNodeLabelIndex)pair.getFirst();
                        TSNodeLabelIndex nodeBDaughter = (TSNodeLabelIndex)pair.getSecond();
                        nodeCollDaughters[i] = collD = CommonSubBranch.getCST(nodeADaughter, nodeBDaughter, CST, collector, currentLength);
                        nodeSetDaughtersLength[i] = size = collD.size();
                        totalComb *= (long)size;
                        ++i;
                    }
                    if (totalComb > (long)maxCombDaughters) {
                        Parameters.appendInLogFile("Skipping comparison: total number of combinaitons to high: " + totalComb + "\n\t" + nodeA + "\n\t" + nodeB);
                        continue;
                    }
                    nodeCollector.addAllCombinations(nodeCollDaughters, nodeSetDaughtersLength, nodeA.index);
                    ++p;
                }
            }
        }
        NodeSetCollector nodeSetCollector = nodeCollector;
        CST[nodeA.index][nodeB.index] = nodeSetCollector;
        return nodeSetCollector;
    }
}

