/*
 * Decompiled with CFR 0.152.
 */
package tsg.corpora;

import java.util.Arrays;

public class Auxify {
    public static String[] suffixes = new String[]{"'VE", "'M", "'LL", "'D", "'S", "'RE"};
    public static String[] auxgs = new String[]{"BEIN", "HAVING", "BEING"};
    public static String[] auxs = new String[]{"MAHT", "SHULD", "WILL", "WAS", "OUGHTA", "AHM", "NEED", "MAYE", "WILLYA", "WHADDYA", "HATH", "HAVE", "WERE", "IS", "HAS", "MUST", "DID", "HAD", "DO", "MIGHT", "WOULD", "SHALL", "SHOULD", "OUGHT", "COULD", "DOES", "HAFTA", "BE", "KIN", "CAN", "ART", "BEEN", "DONE", "ARE", "DOO", "MAY", "AM"};
    public static String[] verbs = new String[]{"VB", "VBD", "VBG", "VBN", "VBP", "VBZ"};

    public static void orderArrays() {
        Arrays.sort(suffixes);
        Arrays.sort(auxgs);
        Arrays.sort(auxs);
        Arrays.sort(verbs);
    }

    public static boolean hasAuxSuf(String word) {
        int pos = word.indexOf(39);
        if (pos == -1) {
            return false;
        }
        String apostrophe = word.substring(pos);
        return Arrays.binarySearch(suffixes, apostrophe) >= 0;
    }

    public static boolean isAux(String word) {
        return Arrays.binarySearch(auxs, word) >= 0;
    }

    public static boolean isAuxg(String word) {
        return Arrays.binarySearch(auxgs, word) >= 0;
    }

    public static boolean isVerb(String word) {
        return Arrays.binarySearch(verbs, word) >= 0;
    }

    public static String auxify(String pos, String trm) {
        String posU = pos.toUpperCase();
        String trmU = trm.toUpperCase();
        if (Auxify.isVerb(posU)) {
            if (Auxify.isAux(trmU) || Auxify.hasAuxSuf(trmU)) {
                return "AUX";
            }
            if (Auxify.isAuxg(trmU)) {
                return "AUXG";
            }
        }
        return null;
    }
}

