/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import tsg.TSNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeAnalizer {
    Hashtable<String, Hashtable> treeStructure = new Hashtable();

    public TreeAnalizer() {
    }

    public TreeAnalizer(Hashtable template_freq) {
        this.addTreeInStructure(template_freq.keySet());
    }

    public void addTreeInStructure(Set treeSet) {
        for (String tree : treeSet) {
            TSNode TN = new TSNode(tree);
            this.insertTreeInStructure(TN, this.treeStructure);
        }
    }

    public String[] getNClosestTrees(int N, String tree) {
        TSNode TN = new TSNode(tree);
        HashSet closestStructure = TreeAnalizer.retriveClosestStrucure(TN, this.treeStructure);
        return TreeAnalizer.getNClosestTrees(N, TN, closestStructure);
    }

    public Object[][] getClosestTrees(String tree) {
        TSNode TN = new TSNode(tree);
        HashSet closestStructure = TreeAnalizer.retriveClosestStrucure(TN, this.treeStructure);
        return TreeAnalizer.getClosestTree(TN, closestStructure);
    }

    private void insertTreeInStructure(TSNode TN, Hashtable structure) {
        TSNode NonEmptyDaughter = null;
        int i = 0;
        while (i < TN.daughters.length) {
            TSNode D = TN.daughters[i];
            if (D.daughters != null) {
                NonEmptyDaughter = D;
                break;
            }
            ++i;
        }
        String label = TN.label;
        Hashtable<String, HashSet<TSNode>> newStructure = (Hashtable<String, HashSet<TSNode>>)structure.get(label);
        if (newStructure == null) {
            newStructure = new Hashtable<String, HashSet<TSNode>>();
            structure.put(label, newStructure);
        }
        if (NonEmptyDaughter == null) {
            while (TN.parent != null) {
                TN = TN.parent;
            }
            HashSet<TSNode> treeSet = (HashSet<TSNode>)newStructure.get("");
            if (treeSet == null) {
                treeSet = new HashSet<TSNode>();
                newStructure.put("", treeSet);
            }
            treeSet.add(TN);
            return;
        }
        this.insertTreeInStructure(NonEmptyDaughter, newStructure);
    }

    private static HashSet retriveClosestStrucure(TSNode TN, Hashtable structure) {
        TSNode NonEmptyDaughter = null;
        int i = 0;
        while (i < TN.daughters.length) {
            TSNode D = TN.daughters[i];
            if (D.daughters != null) {
                NonEmptyDaughter = D;
                break;
            }
            ++i;
        }
        String label = TN.label;
        Hashtable newStructure = (Hashtable)structure.get(label);
        if (newStructure == null) {
            return null;
        }
        if (NonEmptyDaughter == null) {
            HashSet treeSet = (HashSet)newStructure.get("");
            return treeSet;
        }
        return TreeAnalizer.retriveClosestStrucure(NonEmptyDaughter, newStructure);
    }

    /*
     * Unable to fully structure code
     */
    private static Object[][] getClosestTree(TSNode TN, HashSet treeSet) {
        if (treeSet != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            TN = TN.parent;
lbl4:
            // 2 sources

            ** while (TN.parent != null)
        }
lbl5:
        // 1 sources

        TN_LeafHightSet = TreeAnalizer.getLeavesHightSet(TN);
        totalTNLeaves = TN_LeafHightSet.size();
        bestPeers = new HashSet<String>();
        max_equal_leaves = -1;
        min_peer_size = -1;
        for (TSNode peer : treeSet) {
            peer_LeafHightSet = TreeAnalizer.getLeavesHightSet(peer);
            equal_leaves = TreeAnalizer.match(TN_LeafHightSet, peer_LeafHightSet);
            peer_size = peer_LeafHightSet.size();
            if (equal_leaves < max_equal_leaves) continue;
            if (equal_leaves > max_equal_leaves || peer_size < min_peer_size) {
                bestPeers.clear();
                max_equal_leaves = equal_leaves;
                min_peer_size = peer_size;
                bestPeers.add(peer.toString());
                continue;
            }
            if (peer_size != min_peer_size) continue;
            bestPeers.add(peer.toString());
        }
        bestPeersSize = bestPeers.size();
        if (bestPeersSize == 0) {
            return null;
        }
        pearsResults = bestPeers.toArray(new String[bestPeersSize]);
        statistics = new Integer[]{max_equal_leaves, totalTNLeaves, min_peer_size};
        return new Object[][]{pearsResults, statistics};
    }

    private static String[] getNClosestTrees(int N, TSNode TN, HashSet treeSet) {
        while (TN.parent != null) {
            TN = TN.parent;
        }
        LinkedList<Object[]> TN_LeafHightSet = TreeAnalizer.getLeavesHightSet(TN);
        TSNode[] bestPeers = new TSNode[N];
        int[] bestScores = new int[N];
        Arrays.fill(bestScores, -1);
        block1: for (TSNode peer : treeSet) {
            LinkedList<Object[]> peer_LeafHightSet = TreeAnalizer.getLeavesHightSet(peer);
            int score = TreeAnalizer.match(TN_LeafHightSet, peer_LeafHightSet);
            if (score < bestScores[N - 1]) continue;
            int index = 0;
            while (index < N) {
                int indexScore = bestScores[index];
                if (score > indexScore) {
                    if (indexScore != -1) {
                        int backIndex = N - 2;
                        while (backIndex > index - 1) {
                            bestScores[backIndex + 1] = bestScores[backIndex];
                            bestPeers[backIndex + 1] = bestPeers[backIndex];
                            --backIndex;
                        }
                    }
                    bestScores[index] = score;
                    bestPeers[index] = peer;
                    continue block1;
                }
                ++index;
            }
        }
        String[] result = new String[N];
        int i = 0;
        while (i < N) {
            if (bestPeers[i] == null) break;
            result[i] = bestPeers[i].toString();
            ++i;
        }
        return result;
    }

    private static int match(LinkedList<Object[]> node, LinkedList<Object[]> peer) {
        int equal_count = 0;
        ListIterator i = node.listIterator();
        block0: while (i.hasNext()) {
            Object[] node_element = (Object[])i.next();
            ListIterator j = peer.listIterator();
            while (j.hasNext()) {
                Object[] peer_element = (Object[])j.next();
                if (!Arrays.equals(node_element, peer_element)) continue;
                ++equal_count;
                peer_element[2] = new Boolean(true);
                continue block0;
            }
        }
        return equal_count;
    }

    private static LinkedList<Object[]> getLeavesHightSet(TSNode TN) {
        List<TSNode> terminals = TN.collectTerminals();
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        ListIterator<TSNode> i = terminals.listIterator();
        while (i.hasNext()) {
            TSNode L = i.next();
            Integer H = new Integer(L.hight());
            Boolean matched = new Boolean(false);
            result.add(new Object[]{L.label, H, matched});
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

