/*
 * Decompiled with CFR 0.152.
 */
package tsg.LTSG;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import settings.Parameters;
import tsg.LTSG.LTSG;
import tsg.LTSG.LTSG_All;
import tsg.TSNode;
import tsg.corpora.Wsj;
import util.FileUtil;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LTSG_Coverage {
    public static String[] jollyCat = new String[]{",", ":", "-LRB-", "-RRB-", "JJ", "RB", "ADVP", "ADJP"};
    LTSG grammar;
    Hashtable<String, Integer> internalUncovered;
    TreeSet<String> uncoveredRulesSet;

    public LTSG_Coverage(LTSG grammar) {
        this.grammar = grammar;
        this.internalUncovered = new Hashtable();
        this.uncoveredRulesSet = new TreeSet();
        this.convertToSpine();
        Arrays.sort(jollyCat);
        this.removeJollyCat();
    }

    public void convertToSpine() {
        if (!Parameters.spineConversion) {
            return;
        }
        Hashtable<String, Integer> new_templates = new Hashtable<String, Integer>();
        for (String eTree : this.grammar.template_freq.keySet()) {
            TSNode TN = new TSNode(eTree, false);
            Integer count = this.grammar.template_freq.get(eTree);
            TN.convertToSpine();
            new_templates.put(TN.toString(false, true), count);
        }
        this.grammar.template_freq = new_templates;
    }

    public void removeJollyCat() {
        if (jollyCat.length == 0) {
            return;
        }
        Hashtable<String, Integer> new_templates = new Hashtable<String, Integer>();
        for (String eTree : this.grammar.template_freq.keySet()) {
            TSNode TN = new TSNode(eTree, false);
            Integer count = this.grammar.template_freq.get(eTree);
            TN.removeSubstitutionSitesInLexTree(jollyCat);
            new_templates.put(TN.toString(false, true), count);
        }
        this.grammar.template_freq = new_templates;
    }

    public void checkCoverageOnSet() {
        File coverageReport = new File(String.valueOf(Parameters.outputPath) + "CoverageReport");
        File uncoveredSentences = new File(String.valueOf(Parameters.outputPath) + "UncoveredSentences");
        File uncoveredRules = new File(String.valueOf(Parameters.outputPath) + "UncoveredRules");
        File coveredExtrWords = new File(String.valueOf(Parameters.outputPath) + "covered_ExtrWords");
        File coveredGold = new File(String.valueOf(Parameters.outputPath) + "covered_Gold");
        int[] coverage_statistics = new int[8];
        try {
            PrintWriter outputCoverage = new PrintWriter(coverageReport, "ISO-8859-1");
            PrintWriter outputUncovSent = new PrintWriter(uncoveredSentences, "ISO-8859-1");
            PrintWriter outputUncovRules = new PrintWriter(uncoveredRules, "ISO-8859-1");
            PrintWriter outputExtrWord = new PrintWriter(coveredExtrWords, "ISO-8859-1");
            PrintWriter outputGold = new PrintWriter(coveredGold, "ISO-8859-1");
            for (TSNode evalTree : Parameters.testCorpus.treeBank) {
                evalTree.removeHeadAnnotations();
                List<TSNode> terminals = evalTree.collectTerminals();
                List<ArrayList<TSNode>> goldTrees = LTSG.allLexTreesForEachAnchor(evalTree, false, terminals);
                IdentityHashMap<TSNode, TreeSet<Integer>> markTable = new IdentityHashMap<TSNode, TreeSet<Integer>>();
                int terminalIndex = 0;
                for (ArrayList<TSNode> terminalTrees : goldTrees) {
                    boolean unknown;
                    TSNode terminal = terminals.get(terminalIndex);
                    String word = terminal.toString();
                    boolean bl = unknown = this.grammar.lexicon_freq.get(word) == null;
                    if (unknown) continue;
                    Utility.putTreeNodeMark(markTable, terminal, terminalIndex);
                    for (TSNode goldTemplate : terminalTrees) {
                        if (Parameters.spineConversion) {
                            goldTemplate.convertToSpine();
                        } else {
                            goldTemplate.removeSubstitutionSitesInLexTree(jollyCat);
                        }
                        String goldTemplateString = goldTemplate.toString(false, true);
                        goldTemplate = new TSNode(goldTemplateString, false);
                        if (!this.grammar.template_freq.keySet().contains(goldTemplateString)) continue;
                        int depth = goldTemplate.maxDepth(false);
                        Utility.putTreeNodeMark(markTable, terminal, terminalIndex);
                        int i = 0;
                        while (i < depth) {
                            terminal = terminal.parent;
                            Utility.putTreeNodeMark(markTable, terminal, terminalIndex);
                            ++i;
                        }
                        break block4;
                    }
                    ++terminalIndex;
                }
                int temp = coverage_statistics[0];
                boolean covered = this.checkCoverageOnTree(evalTree, markTable, coverage_statistics);
                if (coverage_statistics[0] == temp) {
                    outputExtrWord.write(String.valueOf(evalTree.toExtractWord()) + "\n");
                    outputGold.write(String.valueOf(evalTree.toString()) + "\n");
                }
                evalTree.addMarkersInTree(markTable);
                outputCoverage.write(String.valueOf(evalTree.toString()) + "\n");
                if (covered) continue;
                outputUncovSent.write(String.valueOf(evalTree.toString()) + "\n");
            }
            for (String uncRule : this.uncoveredRulesSet) {
                outputUncovRules.println(uncRule);
            }
            outputUncovSent.close();
            outputUncovRules.close();
            outputCoverage.close();
            outputExtrWord.close();
            outputGold.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
        String report = "Coverage report: \n";
        report = String.valueOf(report) + "\tTOTAL SENTENCES " + Parameters.testCorpus.size() + "\n" + "\tSentences Uncovered " + coverage_statistics[0] + "\n" + "\tNodes Uncovered " + coverage_statistics[1] + "\n" + "\tTop Nodes Uncovered " + coverage_statistics[2] + "\n" + "\tFirst level Nodes Uncovered " + coverage_statistics[3] + "\n" + "\tLexical Uncovered " + coverage_statistics[4] + "\n" + "\tPrelex Uncovered " + coverage_statistics[5] + "(of which referred to Lexical Uncovered " + coverage_statistics[6] + ")\n" + "\tInternal Uncovered " + coverage_statistics[7] + "\n";
        report = String.valueOf(report) + "\nINTERNAL LABELS UNCOVERED \n";
        Enumeration<String> e = this.internalUncovered.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Integer count = this.internalUncovered.get(key);
            report = String.valueOf(report) + "\t" + key + "\t" + count + "\n";
        }
        FileUtil.append(report, coverageReport);
    }

    public boolean checkCoverageOnTree(TSNode evalTree, IdentityHashMap<TSNode, TreeSet<Integer>> markTable, int[] statistics) {
        List<TSNode> nodes = evalTree.collectAllNodes();
        boolean uncovered = false;
        ListIterator<TSNode> i = nodes.listIterator();
        while (i.hasNext()) {
            boolean isJollyCat;
            TSNode node = i.next();
            TreeSet<Integer> indexesInNode = markTable.get(node);
            if (indexesInNode != null) {
                LinkedList<Integer> dominatedLeavesIndex = new LinkedList<Integer>();
                if (!node.isTerminal()) {
                    List<TSNode> leaves = node.collectTerminals();
                    ListIterator<TSNode> l = leaves.listIterator();
                    while (l.hasNext()) {
                        TSNode terminal = l.next();
                        TreeSet<Integer> indexTerminal = markTable.get(terminal);
                        if (indexTerminal == null) continue;
                        dominatedLeavesIndex.addAll(indexTerminal);
                    }
                    indexesInNode.retainAll(dominatedLeavesIndex);
                }
            }
            boolean bl = isJollyCat = Arrays.binarySearch(jollyCat, node.label) >= 0;
            if (indexesInNode != null && !indexesInNode.isEmpty() || isJollyCat) continue;
            uncovered = true;
            this.uncoveredRulesSet.add(node.toCFG(true));
            statistics[1] = statistics[1] + 1;
            if (node.parent == null) {
                statistics[2] = statistics[2] + 1;
                continue;
            }
            if (node.isTerminal()) {
                statistics[4] = statistics[4] + 1;
                continue;
            }
            if (node.hight() == 1) {
                statistics[3] = statistics[3] + 1;
                continue;
            }
            if (node.isPreterminal()) {
                statistics[5] = statistics[5] + 1;
                if (markTable.containsKey(node.daughters[0])) continue;
                statistics[6] = statistics[6] + 1;
                continue;
            }
            statistics[7] = statistics[7] + 1;
            Utility.increaseStringInteger(this.internalUncovered, node.label, 1);
        }
        if (uncovered) {
            statistics[0] = statistics[0] + 1;
        }
        return !uncovered;
    }

    public static void main(String[] args) {
        Parameters.setDefaultParam();
        Wsj.transformNPbasal = false;
        Parameters.lengthLimitTraining = 40;
        Parameters.lengthLimitTest = 40;
        Parameters.semanticTags = false;
        Parameters.ukLimit = 20;
        Wsj.testSet = "22";
        Parameters.spineConversion = true;
        Parameters.LTSGtype = "AllLexTrees";
        Parameters.outputPath = "/home/fsangati/PROJECTS/TSG/RESULTS/LTSG/" + Parameters.LTSGtype + "/";
        LTSG_All Grammar2 = new LTSG_All();
        Grammar2.extractAllLexTrees();
        Grammar2.treatTreeBank();
        Grammar2.checkNegativeFrequencies();
        LTSG_Coverage cov = new LTSG_Coverage(Grammar2);
        cov.checkCoverageOnSet();
    }
}

