/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import tsg.Constituency;
import tsg.TSNode;
import tsg.TSNodeLabel;
import tsg.Yield;
import tsg.YieldConstituency;
import util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexConstituency
extends Constituency {
    int initialIndex;
    int finalIndex;

    public IndexConstituency(String label, int initialIndex, int finalIndex) {
        super(label);
        this.initialIndex = initialIndex;
        this.finalIndex = finalIndex;
    }

    @Override
    public Constituency unlabeledCopy() {
        IndexConstituency copy = new IndexConstituency("", this.initialIndex, this.finalIndex);
        return copy;
    }

    public boolean isCrossing(IndexConstituency c) {
        return this.initialIndex < c.initialIndex && this.finalIndex >= c.initialIndex && this.finalIndex < c.finalIndex || this.initialIndex > c.initialIndex && this.initialIndex <= c.finalIndex && this.finalIndex > c.finalIndex;
    }

    public static int updateCrossingBrackets(List<Constituency> testConst, List<Constituency> goldConst, Hashtable<String, Integer> crossingBracketsCatTable) {
        int result = 0;
        block0: for (Constituency testC : testConst) {
            for (Constituency goldC : goldConst) {
                if (!((IndexConstituency)testC).isCrossing((IndexConstituency)goldC)) continue;
                ++result;
                if (crossingBracketsCatTable == null) continue block0;
                String key = String.valueOf(testC.label) + "/" + goldC.label;
                Utility.increaseStringInteger(crossingBracketsCatTable, key, 1);
                continue block0;
            }
        }
        return result;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof IndexConstituency) {
            IndexConstituency c = (IndexConstituency)anObject;
            if (c.label.equals(this.label) && c.initialIndex == this.initialIndex && c.finalIndex == this.finalIndex) {
                return true;
            }
        }
        return false;
    }

    public static List<Constituency> toYieldConstituency(List<Constituency> list, TSNode tree) {
        ArrayList<Constituency> result = new ArrayList<Constituency>();
        List<TSNode> lexicon = tree.collectLexicalItems();
        for (Constituency C : list) {
            IndexConstituency IC = (IndexConstituency)C;
            List<TSNode> subLex = lexicon.subList(IC.initialIndex, IC.finalIndex + 1);
            String yield = "";
            for (TSNode lex : subLex) {
                yield = String.valueOf(yield) + lex + " ";
            }
            yield = yield.trim();
            result.add(new YieldConstituency(IC.label, new Yield(yield)));
        }
        return result;
    }

    public static List<Constituency> toYieldConstituency(List<Constituency> list, TSNodeLabel tree) {
        ArrayList<Constituency> result = new ArrayList<Constituency>();
        ArrayList<TSNodeLabel> lexicon = tree.collectLexicalItems();
        for (Constituency C : list) {
            IndexConstituency IC = (IndexConstituency)C;
            List subLex = lexicon.subList(IC.initialIndex, IC.finalIndex + 1);
            String yield = "";
            for (TSNodeLabel lex : subLex) {
                yield = String.valueOf(yield) + lex + " ";
            }
            yield = yield.trim();
            result.add(new YieldConstituency(IC.label, new Yield(yield)));
        }
        return result;
    }

    public String toString() {
        return "(" + this.label + ": " + this.initialIndex + "-" + this.finalIndex + ")";
    }
}

