/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.parsingExp.TSGparsingBitPar;

public class TSGparsingBitParNoThreadsSeparate
extends TSGparsingBitPar {
    double lastReadProb;
    MetricOptimizerArray metricOptimizer = new MetricOptimizerArray();

    public TSGparsingBitParNoThreadsSeparate(File trainingFile, File testFile, File fragmentFile, File outputDir) {
        super(trainingFile, testFile, fragmentFile, outputDir);
    }

    @Override
    protected void parseWithBitPar() throws Exception {
        Parameters.reportLineFlush((String)"Parsing with BitPar");
        ArrayList<String[]> testSentencesWords = TSGparsingBitParNoThreadsSeparate.getSentencesWords(this.testTreebank);
        ArrayList<String[]> originalSentencesWords = null;
        if (preprocesUnknownWords) {
            originalSentencesWords = TSGparsingBitParNoThreadsSeparate.getSentencesWords(this.originalTestTreebank);
        }
        Iterator<String[]> testSentenceIterator = testSentencesWords.iterator();
        Iterator<String[]> originalTestSentenceIterator = originalSentencesWords.iterator();
        while (testSentenceIterator.hasNext()) {
            String[] testSentenceWords = testSentenceIterator.next();
            String[] originalSentenceWords = originalTestSentenceIterator.next();
            try {
                String line;
                Process p = Runtime.getRuntime().exec(bitparCommandAndArgs);
                BufferedWriter output = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                BufferedReader inputStd = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader inputErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String[] stringArray = testSentenceWords;
                int n = testSentenceWords.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    output.write(String.valueOf(word) + "\n");
                    ++n2;
                }
                output.write("\n");
                output.flush();
                output.close();
                this.metricOptimizer.prepareNextSentence(originalSentenceWords);
                while ((line = inputStd.readLine()) != null) {
                    this.processLine(line);
                }
                inputStd.close();
                while ((line = inputErr.readLine()) != null) {
                }
                inputErr.close();
                this.doneWithOneSentence();
            }
            catch (Exception err) {
                err.printStackTrace();
                return;
            }
        }
        this.parsedOutputFiles = this.metricOptimizer.makeFileOutputList(String.valueOf(this.outputPath) + "BITPAR_", ".mrg");
        this.parsedOutputFilesIdentifiers = this.metricOptimizer.getIdentifiers();
        this.metricOptimizer.appendResult(this.parsedOutputFiles);
        Parameters.reportLineFlush((String)"Finished Parsing.");
    }

    private void processLine(String line) throws Exception {
        if (line.equals("")) {
            this.metricOptimizer.storeCurrentBestParseTrees();
            return;
        }
        if (line.charAt(0) == '(') {
            TSNodeLabel tree = null;
            Object fragmentConvertedString = null;
            line = line.replaceAll("\\\\", "");
            try {
                tree = new TSNodeLabel(line);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tree = this.postProcessParseTree(tree);
            this.metricOptimizer.addNewDerivation(tree, this.lastReadProb);
            return;
        }
        if (line.startsWith("vitprob=")) {
            this.lastReadProb = Double.parseDouble(line.substring(viterbProbPrefixLength));
            return;
        }
        if (line.startsWith("No parse for: ")) {
            TSNodeLabel tree = this.dealWithNOParsedSentences(this.metricOptimizer.getCurrentSentenceWords());
            this.metricOptimizer.addNewDerivation(tree, this.lastReadProb);
            return;
        }
        Parameters.reportLineFlush((String)("Unknown line in bitpar output: " + line));
    }
}

