/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.parsingExp.TSGparsingBitPar;
import util.FileUtil;
import util.Utility;

public class TSGparsingBitParFileSeparate
extends TSGparsingBitPar {
    String bitParBuildingFilesPath;

    public TSGparsingBitParFileSeparate(File trainingFile, File testFile, File fragmentFile, File outputDir) {
        super(trainingFile, testFile, fragmentFile, outputDir);
        this.bitParBuildingFilesPath = String.valueOf(this.outputPath) + "BitParWorkingDir/";
    }

    @Override
    protected void parseWithBitPar() throws Exception {
        Parameters.reportLineFlush((String)"Preparing threads");
        File bitParBuildingFilesDir = new File(this.bitParBuildingFilesPath);
        bitParBuildingFilesDir.mkdir();
        int threadLength = Integer.toString(threads).length();
        int sentencesPerThreads = this.testSize / threads;
        int remainingSentences = this.testSize % threads;
        ArrayList<String[]> testSentencesWords = TSGparsingBitParFileSeparate.getSentencesWords(this.testTreebank);
        ArrayList<String[]> originalSentencesWords = preprocesUnknownWords ? TSGparsingBitParFileSeparate.getSentencesWords(this.originalTestTreebank) : null;
        BitParThreadRunner[] bitParThreadArray = new BitParThreadRunner[threads];
        int reachedIndex = 0;
        int i = 0;
        while (i < threads) {
            int threadIndex = i + 1;
            String number = Utility.padZero(threadLength, threadIndex);
            int sentencesThreads = sentencesPerThreads;
            if (i < remainingSentences) {
                ++sentencesThreads;
            }
            int startingIndex = reachedIndex;
            ArrayList<String[]> testSentencesWordsThread = new ArrayList<String[]>(testSentencesWords.subList(startingIndex, reachedIndex += sentencesThreads));
            ArrayList<String[]> originalTestSentencesWordsThread = null;
            if (preprocesUnknownWords) {
                originalTestSentencesWordsThread = new ArrayList<String[]>(originalSentencesWords.subList(startingIndex, reachedIndex));
            }
            bitParThreadArray[i] = new BitParThreadRunner(threadIndex, sentencesThreads, testSentencesWordsThread, originalTestSentencesWordsThread, number);
            ++i;
        }
        Parameters.reportLineFlush((String)("Parsing with BitPar using " + threads + " threads"));
        Parameters.reportLineFlush((String)("Parsing " + this.testSize + " sentences:"));
        this.submitMultithreadJob(bitParThreadArray);
        this.parsedOutputFiles = bitParThreadArray[0].metricOptimizer.makeFileOutputList(String.valueOf(this.outputPath) + "BITPAR_", ".mrg");
        this.parsedOutputFilesIdentifiers = bitParThreadArray[0].metricOptimizer.getIdentifiers();
        BitParThreadRunner[] bitParThreadRunnerArray = bitParThreadArray;
        int n = bitParThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            BitParThreadRunner t = bitParThreadRunnerArray[n2];
            t.metricOptimizer.appendResult(this.parsedOutputFiles);
            ++n2;
        }
        Parameters.reportLineFlush((String)"Finished Parsing.");
    }

    private void submitMultithreadJob(BitParThreadRunner[] bitParThreadArray) {
        int i = 0;
        while (i < threads - 1) {
            BitParThreadRunner t = bitParThreadArray[i];
            t.start();
            ++i;
        }
        bitParThreadArray[threads - 1].run();
        i = 0;
        while (i < threads - 1) {
            try {
                bitParThreadArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            ++i;
        }
    }

    protected class BitParThreadRunner
    extends Thread {
        int threadIndex;
        int numberSentences;
        ArrayList<String[]> testSentencesWordsThread;
        ArrayList<String[]> originalTestSentencesWordsThread;
        String threadNumberString;
        MetricOptimizerArray metricOptimizer;

        public BitParThreadRunner(int threadIndex, int numberSentences, ArrayList<String[]> testSentencesWordsThread, ArrayList<String[]> originalTestSentencesWordsThread, String threadNumberString) {
            this.threadIndex = threadIndex;
            this.numberSentences = numberSentences;
            this.testSentencesWordsThread = testSentencesWordsThread;
            this.originalTestSentencesWordsThread = originalTestSentencesWordsThread;
            this.threadNumberString = threadNumberString;
            this.metricOptimizer = new MetricOptimizerArray();
        }

        @Override
        public void run() {
            Process p = null;
            int maxIndexSize = Integer.toString(this.numberSentences).length();
            Iterator<String[]> testSentencesIterator = this.testSentencesWordsThread.iterator();
            Iterator<String[]> originalTestSentencesIterator = preprocesUnknownWords ? this.originalTestSentencesWordsThread.iterator() : null;
            int currentIndex = 0;
            while (currentIndex < this.numberSentences) {
                String currentIndexString = Utility.padZero(maxIndexSize, currentIndex);
                String[] testSentence = testSentencesIterator.next();
                String[] originalSentence = preprocesUnknownWords ? originalTestSentencesIterator.next() : null;
                File outputBitParNbestSentence = new File(String.valueOf(TSGparsingBitParFileSeparate.this.bitParBuildingFilesPath) + "outputBitPar_" + nBest + "best_" + "thread" + this.threadNumberString + "_" + currentIndexString + ".txt");
                File flatFileForBitParSentence = new File(String.valueOf(TSGparsingBitParFileSeparate.this.bitParBuildingFilesPath) + "flatFileForBitPar_thread" + this.threadNumberString + "_" + currentIndexString + ".txt");
                TSGparsingBitParFileSeparate.printBitParFlatSentence(testSentence, flatFileForBitParSentence);
                try {
                    p = Runtime.getRuntime().exec(String.valueOf(bitparCommandAndArgs) + " " + flatFileForBitParSentence + " " + outputBitParNbestSentence);
                    BufferedReader inputStd = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    BufferedReader inputErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    ReadInputStream inputStandardThread = new ReadInputStream(inputStd);
                    ReadErrorStream inputErrorThread = new ReadErrorStream(inputErr);
                    inputStandardThread.start();
                    inputErrorThread.start();
                    try {
                        inputStandardThread.join();
                        inputErrorThread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                    inputStd.close();
                    inputErr.close();
                }
                catch (IOException err) {
                    err.printStackTrace();
                    return;
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    this.postProcessNbest(outputBitParNbestSentence, originalSentence);
                }
                catch (Exception err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush((String)err.getMessage());
                    return;
                }
                ++currentIndex;
            }
        }

        private void postProcessNbest(File outputBitParNbestSentence, String[] originalSentence) throws Exception {
            Scanner scan = FileUtil.getScanner(outputBitParNbestSentence);
            if (!scan.hasNextLine()) {
                Parameters.reportLineFlush((String)"EMPTY FILE!!!!");
                scan.close();
                return;
            }
            double lastReadProb = -1.0;
            TSNodeLabel tree = null;
            this.metricOptimizer.prepareNextSentence(originalSentence);
            while (scan.hasNextLine()) {
                String line = scan.nextLine();
                if (line.equals("")) {
                    this.metricOptimizer.storeCurrentBestParseTrees();
                    continue;
                }
                if (line.charAt(0) == '(') {
                    line = line.replaceAll("\\\\", "");
                    try {
                        tree = new TSNodeLabel(line);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    tree = TSGparsingBitParFileSeparate.this.postProcessParseTree(tree);
                    this.metricOptimizer.addNewDerivation(tree, lastReadProb);
                    continue;
                }
                if (line.startsWith("vitprob=")) {
                    lastReadProb = Double.parseDouble(line.substring(viterbProbPrefixLength));
                    continue;
                }
                if (line.startsWith("No parse for: ")) {
                    tree = TSGparsingBitParFileSeparate.this.dealWithNOParsedSentences(originalSentence);
                    this.metricOptimizer.addNewDerivation(tree, lastReadProb);
                    continue;
                }
                System.out.println("Unknown line in bitpar output: " + line);
            }
            scan.close();
        }

        protected class ReadErrorStream
        extends Thread {
            BufferedReader input;
            String reportPrefix;
            float parsingTime;

            public ReadErrorStream(BufferedReader input) {
                this.input = input;
                this.reportPrefix = "[stdErr_" + BitParThreadRunner.this.threadIndex + "]:";
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        if (line.equals("")) continue;
                        if (Character.isDigit(line.charAt(0))) {
                            TSGparsingBitParFileSeparate.this.doneWithOneSentence();
                            continue;
                        }
                        if (line.startsWith("reading") || line.startsWith("parameter") || line.startsWith("finished") || line.startsWith("raw")) continue;
                        Parameters.reportLineFlush((String)(String.valueOf(this.reportPrefix) + line));
                    }
                }
                catch (IOException err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush((String)err.getMessage());
                    return;
                }
            }
        }

        protected class ReadInputStream
        extends Thread {
            BufferedReader input;
            String reportPrefix;

            public ReadInputStream(BufferedReader input) {
                this.input = input;
                this.reportPrefix = "[stdOut_" + BitParThreadRunner.this.threadIndex + "]:";
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        Parameters.reportLineFlush((String)(String.valueOf(this.reportPrefix) + line));
                    }
                }
                catch (IOException err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush((String)err.getMessage());
                    return;
                }
            }
        }
    }
}

