/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.parsingExp.TSGparsingBitPar;

public class TSGparsingBitParDirectSeparate
extends TSGparsingBitPar {
    public TSGparsingBitParDirectSeparate(File trainingFile, File testFile, File fragmentFile, File outputDir) {
        super(trainingFile, testFile, fragmentFile, outputDir);
    }

    @Override
    protected void parseWithBitPar() throws Exception {
        Parameters.reportLineFlush((String)"Preparing threads");
        int sentencesPerThreads = this.testSize / threads;
        int remainingSentences = this.testSize % threads;
        ArrayList<String[]> testSentencesWords = TSGparsingBitParDirectSeparate.getSentencesWords(this.testTreebank);
        ArrayList<String[]> originalSentencesWords = preprocesUnknownWords ? TSGparsingBitParDirectSeparate.getSentencesWords(this.originalTestTreebank) : null;
        BitParThreadRunner[] bitParThreadArray = new BitParThreadRunner[threads];
        int reachedIndex = 0;
        int i = 0;
        while (i < threads) {
            int threadIndex = i + 1;
            int sentencesThreads = sentencesPerThreads;
            if (i < remainingSentences) {
                ++sentencesThreads;
            }
            int startingIndex = reachedIndex;
            ArrayList<String[]> testSentencesWordsThread = new ArrayList<String[]>(testSentencesWords.subList(startingIndex, reachedIndex += sentencesThreads));
            ArrayList<String[]> originalTestSentencesWordsThread = null;
            if (preprocesUnknownWords) {
                originalTestSentencesWordsThread = new ArrayList<String[]>(originalSentencesWords.subList(startingIndex, reachedIndex));
            }
            bitParThreadArray[i] = new BitParThreadRunner(threadIndex, startingIndex, testSentencesWordsThread, originalTestSentencesWordsThread);
            ++i;
        }
        Parameters.reportLineFlush((String)("Parsing with BitPar using " + threads + " threads"));
        Parameters.reportLineFlush((String)("Parsing " + this.testSize + " sentences:"));
        this.submitMultithreadJob(bitParThreadArray);
        this.parsedOutputFiles = bitParThreadArray[0].metricOptimizer.makeFileOutputList(String.valueOf(this.outputPath) + "BITPAR_", ".mrg");
        this.parsedOutputFilesIdentifiers = bitParThreadArray[0].metricOptimizer.getIdentifiers();
        BitParThreadRunner[] bitParThreadRunnerArray = bitParThreadArray;
        int n = bitParThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            BitParThreadRunner t = bitParThreadRunnerArray[n2];
            t.metricOptimizer.appendResult(this.parsedOutputFiles);
            ++n2;
        }
        Parameters.reportLineFlush((String)"Finished Parsing.");
    }

    private void submitMultithreadJob(BitParThreadRunner[] bitParThreadArray) {
        int i = 0;
        while (i < threads - 1) {
            BitParThreadRunner t = bitParThreadArray[i];
            t.start();
            ++i;
        }
        bitParThreadArray[threads - 1].run();
        i = 0;
        while (i < threads - 1) {
            try {
                bitParThreadArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            ++i;
        }
    }

    protected class BitParThreadRunner
    extends Thread {
        int threadIndex;
        int startSentenceIndex;
        ArrayList<String[]> flatSentencesForBitPar;
        ArrayList<String[]> originalTestSentencesWordsThread;
        MetricOptimizerArray metricOptimizer;

        public BitParThreadRunner(int threadIndex, int startSentenceIndex, ArrayList<String[]> testSentencesWordsThread, ArrayList<String[]> originalTestSentencesWordsThread) {
            this.threadIndex = threadIndex;
            this.startSentenceIndex = startSentenceIndex;
            this.flatSentencesForBitPar = testSentencesWordsThread;
            this.originalTestSentencesWordsThread = originalTestSentencesWordsThread;
            this.metricOptimizer = new MetricOptimizerArray();
        }

        @Override
        public void run() {
            Process p = null;
            int currentSentenceIndex = 0;
            Iterator<String[]> originalTestIterator = null;
            String[] originalTestSentenceWords = null;
            if (preprocesUnknownWords) {
                originalTestIterator = this.originalTestSentencesWordsThread.iterator();
                originalTestSentenceWords = originalTestIterator.next();
            }
            for (String[] flatSentence : this.flatSentencesForBitPar) {
                try {
                    p = Runtime.getRuntime().exec(bitparCommandAndArgs);
                    BufferedWriter output = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                    BufferedReader inputStd = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    BufferedReader inputErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    ReadInputStream inputStandardThread = new ReadInputStream(inputStd, currentSentenceIndex, originalTestSentenceWords);
                    ReadErrorStream inputErrorThread = new ReadErrorStream(inputErr);
                    inputStandardThread.start();
                    inputErrorThread.start();
                    String[] stringArray = flatSentence;
                    int n = flatSentence.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String word = stringArray[n2];
                        output.write(String.valueOf(word) + "\n");
                        ++n2;
                    }
                    output.write("\n");
                    output.flush();
                    output.close();
                    try {
                        inputStandardThread.join();
                        inputErrorThread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return;
                    }
                    inputStd.close();
                    inputErr.close();
                }
                catch (IOException err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush((String)err.getMessage());
                    return;
                }
                ++currentSentenceIndex;
                if (!preprocesUnknownWords || !originalTestIterator.hasNext()) continue;
                originalTestSentenceWords = originalTestIterator.next();
            }
        }

        protected class ReadErrorStream
        extends Thread {
            BufferedReader input;
            String reportPrefix;
            int currentSentenceIndex;
            float parsingTime;

            public ReadErrorStream(BufferedReader input) {
                this.currentSentenceIndex = BitParThreadRunner.this.startSentenceIndex;
                this.input = input;
                this.reportPrefix = "[stdOutErr_" + BitParThreadRunner.this.threadIndex + "]:";
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        if (line.equals("")) continue;
                        if (Character.isDigit(line.charAt(0))) {
                            TSGparsingBitParDirectSeparate.this.doneWithOneSentence();
                            continue;
                        }
                        if (line.startsWith("reading") || line.startsWith("parameter") || line.startsWith("finished") || line.startsWith("raw")) continue;
                        Parameters.reportLineFlush((String)(String.valueOf(this.reportPrefix) + line));
                    }
                }
                catch (IOException err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush((String)err.getMessage());
                    return;
                }
            }
        }

        protected class ReadInputStream
        extends Thread {
            BufferedReader input;
            double lastReadProb;
            String[] originalTestSentenceWords;

            public ReadInputStream(BufferedReader input, int currentSentenceIndex, String[] originalTestSentenceWords) {
                this.input = input;
                this.originalTestSentenceWords = originalTestSentenceWords;
                BitParThreadRunner.this.metricOptimizer.prepareNextSentence(originalTestSentenceWords);
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        this.processLine(line);
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush((String)err.getMessage());
                    return;
                }
            }

            private void processLine(String line) throws Exception {
                if (line.equals("")) {
                    BitParThreadRunner.this.metricOptimizer.storeCurrentBestParseTrees();
                    return;
                }
                if (line.charAt(0) == '(') {
                    TSNodeLabel tree = null;
                    line = line.replaceAll("\\\\", "");
                    try {
                        tree = new TSNodeLabel(line);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    tree = TSGparsingBitParDirectSeparate.this.postProcessParseTree(tree);
                    BitParThreadRunner.this.metricOptimizer.addNewDerivation(tree, this.lastReadProb);
                    return;
                }
                if (line.startsWith("vitprob=")) {
                    this.lastReadProb = Double.parseDouble(line.substring(viterbProbPrefixLength));
                    return;
                }
                if (line.startsWith("No parse for: ")) {
                    TSNodeLabel tree = TSGparsingBitParDirectSeparate.this.dealWithNOParsedSentences(this.originalTestSentenceWords);
                    BitParThreadRunner.this.metricOptimizer.addNewDerivation(tree, this.lastReadProb);
                    return;
                }
                Parameters.reportLineFlush((String)("Unknown line in bitpar output: " + line));
            }
        }
    }
}

