/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Vector;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.mb.TreeMarkoBinarization;
import tsg.mb.TreeMarkoBinarizationLeft_Petrov;
import tsg.parsingExp.ConvertFragmentsToCFGRulesInt;
import util.ArgumentReader;
import util.FileUtil;

public class PostProcessFSParses {
    static final String lexPosSeparationString = "^";
    static final char lexPosSeparationChar = "^".charAt(0);
    static final String internalFakeNodeLabel = "NODE@";
    static final int internalFakeNodeLabelLength = 5;
    static final String fakePrelexPrefix = "^";
    static TreeMarkoBinarizationLeft_Petrov treeMarkovBinarizer;
    static Vector<TSNodeLabel> ambiguousCFGmapping;
    static Hashtable<String, TSNodeLabel> unambiguousCFGmapping;

    public static TSNodeLabel postProcessParseTree(TSNodeLabel tree) {
        tree = PostProcessFSParses.replaceRulesWithFragments(tree);
        tree = treeMarkovBinarizer.undoMarkovBinarization(tree);
        return tree;
    }

    private static TSNodeLabel replaceRulesWithFragments(TSNodeLabel tree) {
        String firstDaughetLabel = tree.firstDaughter().label();
        boolean ambiguousFragment = firstDaughetLabel.startsWith(internalFakeNodeLabel);
        TSNodeLabel fragment = null;
        if (ambiguousFragment) {
            int index = 0;
            try {
                String digits = firstDaughetLabel.substring(5);
                index = Integer.parseInt(digits);
            }
            catch (StringIndexOutOfBoundsException e) {
                Parameters.reportLineFlush((String)("Error302: " + firstDaughetLabel + " " + tree));
                return null;
            }
            fragment = ambiguousCFGmapping.get(index);
            if (fragment == null) {
                Parameters.reportError((String)("Couldn't find the fragment uniquely associated with unique index:" + index));
                return null;
            }
            tree.daughters = tree.firstDaughter().daughters;
        } else {
            fragment = unambiguousCFGmapping.get(tree.cfgRule());
        }
        TSNodeLabel result = fragment.clone();
        ArrayList<TSNodeLabel> terminals = result.collectTerminalItems();
        Iterator<TSNodeLabel> termIter = terminals.iterator();
        TSNodeLabel[] tSNodeLabelArray = tree.daughters;
        int n = tree.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            TSNodeLabel term = termIter.next();
            if (!term.isLexical) {
                TSNodeLabel subFragment = PostProcessFSParses.replaceRulesWithFragments(d);
                term.daughters = subFragment.daughters;
                TSNodeLabel[] tSNodeLabelArray2 = subFragment.daughters;
                int n3 = subFragment.daughters.length;
                int n4 = 0;
                while (n4 < n3) {
                    TSNodeLabel d1 = tSNodeLabelArray2[n4];
                    d1.parent = subFragment;
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        TreeMarkoBinarization.markH = 1;
        TreeMarkoBinarization.markV = 2;
        treeMarkovBinarizer = new TreeMarkoBinarizationLeft_Petrov();
        File fragmentsAndCfg = ArgumentReader.readFileOptionNoSeparation(args[0]);
        File inputFile = ArgumentReader.readFileOptionNoSeparation(args[1]);
        File outputFile = ArgumentReader.readFileOptionNoSeparation(args[2]);
        ConvertFragmentsToCFGRulesInt converter = new ConvertFragmentsToCFGRulesInt(fragmentsAndCfg, new File("ambiguousFragmetnsCFG_bis.txt"), new File("bitpar_grammar_bis.txt"), internalFakeNodeLabel, "^");
        ambiguousCFGmapping = converter.getAmbiguousCFGmapping();
        unambiguousCFGmapping = converter.getunambiguousCFGmapping();
        Scanner scan = FileUtil.getScanner(inputFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            TSNodeLabel tree = PostProcessFSParses.postProcessParseTree(new TSNodeLabel(line));
            pw.println(tree.toString());
        }
        pw.close();
    }
}

