/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser.petrov;

import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Scanner;
import settings.Parameters;
import tsg.CFSG;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.parseEval.EvalB;
import tsg.parseEval.EvalC;
import tsg.parser.Parser;
import util.FileUtil;
import util.Utility;
import wordModel.UkWordMapping;
import wordModel.UkWordMappingPetrov;

public class RunPetrovGrammarWithFedepar
extends Thread {
    static UkWordMapping ukModel;
    static int nBest;
    static String topSymbol;
    static double minProbRule;
    static File petrovGrammarFile;
    static File petrovLexiconFile;
    static File outputDir;
    static int threads;
    static File trainTreebankFile;
    static File testTreebankFile;
    static int sentenceLengthLimitTest;
    String outputPath;
    File testTreebankFileClean;
    ArrayList<TSNodeLabel> originalTrainingTreebank;
    ArrayList<TSNodeLabel> trainingTreebank;
    ArrayList<TSNodeLabel> originalTestTreebank;
    ArrayList<TSNodeLabel> testTreebank;
    int testSize;
    Hashtable<String, Double> lexicon;
    Hashtable<String, Double> internalRules;
    File flatTestSet;
    File parsedFile;
    static String regexConvertLabel;
    static String regexCleanProb;

    static {
        regexConvertLabel = "\\^g";
        regexCleanProb = "[\\[\\]\\,]";
    }

    @Override
    public void run() {
        this.outputPath = outputDir + "/" + "Parsing_" + FileUtil.dateTimeString() + "/";
        new File(this.outputPath).mkdir();
        Parameters.openLogFile((File)new File(String.valueOf(this.outputPath) + "log.txt"));
        this.outputParametersToLogFile();
        this.testTreebankFileClean = new File(String.valueOf(this.outputPath) + testTreebankFile.getName());
        this.getTrainingAndTestTreebanks();
        this.preprocessUnknownWords();
        this.convertGrammar();
        this.convertLexicon();
        this.writeFlatTest();
        try {
            this.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.parseEval();
    }

    private void writeFlatTest() {
        this.flatTestSet = new File(String.valueOf(this.outputPath) + "test.flat");
        PrintWriter pw = FileUtil.getPrintWriter(this.flatTestSet);
        for (TSNodeLabel t : this.testTreebank) {
            pw.println(t.toFlatSentence());
        }
        pw.close();
    }

    private void parse() throws Exception {
        Parameters.reportLineFlush((String)"Parsing with FedePar");
        Parameters.reportLineFlush((String)("Parsing " + this.testSize + " sentences:"));
        Parameters.nBest = 1;
        CFSG<Double> grammar = new CFSG<Double>(this.lexicon, this.internalRules);
        this.parsedFile = new File(String.valueOf(this.outputPath) + "fedPar_parsed.mrg");
        new Parser(grammar, this.flatTestSet, this.parsedFile);
    }

    private void parseEval() {
        Parameters.reportLineFlush((String)"Running EvalB and EvalC");
        DecimalFormat df = new DecimalFormat("0.00");
        File evalBfile = FileUtil.changeExtention(this.parsedFile, "evalB");
        File evalCfile = FileUtil.changeExtention(this.parsedFile, "evalC");
        new EvalB(this.testTreebankFileClean, this.parsedFile, evalBfile);
        EvalC eval = new EvalC(this.testTreebankFileClean, this.parsedFile, evalCfile, null, true);
        float[] results = eval.makeEval();
        Parameters.reportLineFlush((String)(String.valueOf(Utility.fse(15, "MPD")) + ":\tRecall, Precision, Fscore (<=" + EvalC.CUTOFF_LENGTH + "):  [" + df.format(results[0]) + ", " + df.format(results[1]) + ", " + df.format(results[2]) + "]"));
    }

    private void getTrainingAndTestTreebanks() {
        try {
            Parameters.reportLineFlush((String)"Reading Traininig Treebank");
            this.trainingTreebank = TSNodeLabel.getTreebank(trainTreebankFile);
            int trainingSize = this.trainingTreebank.size();
            Parameters.reportLineFlush((String)("Traininig Treebank Size: " + trainingSize));
            Parameters.reportLineFlush((String)"Reading Test Treebank");
            this.testTreebank = TSNodeLabel.getTreebank(testTreebankFile, sentenceLengthLimitTest);
            TSNodeLabel.printTreebankToFile(this.testTreebankFileClean, this.testTreebank, false, false);
            this.testSize = this.testTreebank.size();
            Parameters.reportLineFlush((String)("Test Treebank Size: " + this.testSize));
            this.originalTrainingTreebank = this.trainingTreebank;
            this.originalTestTreebank = this.testTreebank;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void preprocessUnknownWords() {
        Parameters.reportLineFlush((String)("Processing Unknown Words with model: " + ukModel.getClass()));
        Parameters.reportLineFlush((String)("UK threshold: " + UkWordMapping.ukThreashold));
        ukModel.init(this.trainingTreebank, this.testTreebank);
        this.trainingTreebank = ukModel.transformTrainingTreebank();
        this.testTreebank = ukModel.transformTestTreebank();
        File transformedTrainingTreBankFile = new File(String.valueOf(this.outputPath) + "trainingTreebank_UK.mrg");
        File transformedTestTreBankFile = new File(String.valueOf(this.outputPath) + "testTreebank_UK.mrg");
        TSNodeLabel.printTreebankToFile(transformedTrainingTreBankFile, this.trainingTreebank, false, false);
        TSNodeLabel.printTreebankToFile(transformedTestTreBankFile, this.testTreebank, false, false);
        Parameters.reportLineFlush((String)("Printed training treebank after unknonw word process to: " + transformedTrainingTreBankFile));
        Parameters.reportLineFlush((String)("Printed test treebank after unknonw word process to: " + transformedTestTreBankFile));
    }

    private void convertGrammar() {
        Parameters.reportLineFlush((String)"Extracting internal rules");
        this.internalRules = new Hashtable();
        Scanner grammarScan = FileUtil.getScanner(petrovGrammarFile);
        while (grammarScan.hasNextLine()) {
            int length;
            String line = grammarScan.nextLine();
            String[] lineSplit = line.split("\\s");
            double prob = Double.parseDouble(lineSplit[(length = lineSplit.length) - 1]);
            if (prob < minProbRule) continue;
            String rule = RunPetrovGrammarWithFedepar.convertLable(lineSplit[0]);
            int i = 2;
            while (i < length - 1) {
                rule = String.valueOf(rule) + " " + RunPetrovGrammarWithFedepar.convertLable(lineSplit[i]);
                ++i;
            }
            this.internalRules.put(rule, prob);
        }
    }

    private static String convertLable(String label) {
        return label.replace('_', '-').replaceFirst(regexConvertLabel, "");
    }

    private void convertLexicon() {
        Parameters.reportLineFlush((String)"Extracting lexical rules");
        this.lexicon = new Hashtable();
        Scanner lexiconScan = FileUtil.getScanner(petrovLexiconFile);
        while (lexiconScan.hasNextLine()) {
            String line = lexiconScan.nextLine();
            line = line.replaceAll("\\\\", "");
            String[] lineSplit = line.split("\\s");
            int length = lineSplit.length;
            String pos = lineSplit[0];
            String lex = lineSplit[1];
            int index = 0;
            int i = 2;
            while (i < length) {
                double prob = RunPetrovGrammarWithFedepar.cleanProb(lineSplit[i]);
                if (prob > minProbRule) {
                    String rule = String.valueOf(pos) + "-" + index + " " + lex;
                    this.lexicon.put(rule, prob);
                }
                ++index;
                ++i;
            }
        }
    }

    private static double cleanProb(String p) {
        return Double.parseDouble(p.replaceAll(regexCleanProb, ""));
    }

    private void outputParametersToLogFile() {
        Parameters.reportLine((String)("nBest: " + nBest));
        Parameters.reportLine((String)("topSymbol: " + topSymbol));
        Parameters.reportLine((String)("sentenceLengthLimitTest: " + sentenceLengthLimitTest));
        Parameters.reportLine((String)("minProbRule: " + minProbRule));
        Parameters.reportLine((String)("petrovGrammarFile: " + petrovGrammarFile));
        Parameters.reportLine((String)("petrovLexiconFile: " + petrovLexiconFile));
        Parameters.reportLine((String)("trainTreebankFile: " + trainTreebankFile));
        Parameters.reportLine((String)("testTreebankFile: " + testTreebankFile));
        Parameters.reportLineFlush((String)("threads: " + threads));
    }

    public static void main(String[] args) throws Exception {
        UkWordMapping.ukThreashold = 0;
        ukModel = new UkWordMappingPetrov();
        nBest = 1000;
        topSymbol = "ROOT-0";
        sentenceLengthLimitTest = 40;
        minProbRule = 1.0E-50;
        MetricOptimizerArray.setLambdaValues(0.0, 2.0, 0.5);
        petrovGrammarFile = new File(args[0]);
        petrovLexiconFile = new File(args[1]);
        outputDir = new File(args[2]);
        trainTreebankFile = new File(args[3]);
        testTreebankFile = new File(args[4]);
        threads = Integer.parseInt(args[5]);
        new RunPetrovGrammarWithFedepar().run();
    }
}

