/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser.petrov;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.metrics.MetricOptimizerArray;
import tsg.utils.CleanPetrov;
import util.PrintProgress;

public class BitParParserPetrov
extends Thread {
    static final String viterbProbPrefix = "vitprob=";
    static final String noParseMessage = "No parse for: ";
    static final int viterbProbPrefixLength = "vitprob=".length();
    ArrayList<TSNodeLabel> testTreebank;
    ArrayList<TSNodeLabel> originalTestTreebank;
    int testSize;
    int threads;
    String outputPath;
    String topSymbol;
    File[] parsedOutputFiles;
    String[] parsedOutputFilesIdentifiers;
    String bitparCommandAndArgs;
    PrintProgress progress;

    public BitParParserPetrov(ArrayList<TSNodeLabel> testTreebank, ArrayList<TSNodeLabel> originalTestTreebank, int threads, String outputPath, File bitparGrammarFile, File bitparLexiconFile, int nBest, String topSymbol) {
        this.testTreebank = testTreebank;
        this.originalTestTreebank = originalTestTreebank;
        this.threads = threads;
        this.outputPath = outputPath;
        this.testSize = testTreebank.size();
        this.progress = new PrintProgress("Sentence #:");
        this.topSymbol = topSymbol;
        this.bitparCommandAndArgs = String.valueOf(Parameters.bitparApp) + " -vp -b " + nBest + " -s " + topSymbol + " " + bitparGrammarFile + " " + bitparLexiconFile;
    }

    public File[] getParsedFiles() {
        return this.parsedOutputFiles;
    }

    public String[] getParsedFilesIdentifiers() {
        return this.parsedOutputFilesIdentifiers;
    }

    protected void runParser() throws Exception {
        int sentencesPerThreads = this.testSize / this.threads;
        int remainingSentences = this.testSize % this.threads;
        ArrayList<String[]> testSentencesWords = BitParParserPetrov.getSentencesWords(this.testTreebank);
        ArrayList<String[]> originalSentencesWords = BitParParserPetrov.getSentencesWords(this.originalTestTreebank);
        BitParThreadRunner[] bitParThreadArray = new BitParThreadRunner[this.threads];
        int reachedIndex = 0;
        int i = 0;
        while (i < this.threads) {
            int threadIndex = i + 1;
            int sentencesThreads = sentencesPerThreads;
            if (i < remainingSentences) {
                ++sentencesThreads;
            }
            int startingIndex = reachedIndex;
            ArrayList<String[]> testSentencesWordsThread = new ArrayList<String[]>(testSentencesWords.subList(startingIndex, reachedIndex += sentencesThreads));
            ArrayList<String[]> originalTestSentencesWordsThread = null;
            originalTestSentencesWordsThread = new ArrayList<String[]>(originalSentencesWords.subList(startingIndex, reachedIndex));
            bitParThreadArray[i] = new BitParThreadRunner(threadIndex, startingIndex, testSentencesWordsThread, originalTestSentencesWordsThread);
            ++i;
        }
        this.submitMultithreadJob(bitParThreadArray);
        this.parsedOutputFiles = bitParThreadArray[0].metricOptimizer.makeFileOutputList(String.valueOf(this.outputPath) + "BITPAR_", ".mrg");
        this.parsedOutputFilesIdentifiers = bitParThreadArray[0].metricOptimizer.getIdentifiers();
        BitParThreadRunner[] bitParThreadRunnerArray = bitParThreadArray;
        int n = bitParThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            BitParThreadRunner t = bitParThreadRunnerArray[n2];
            t.metricOptimizer.appendResult(this.parsedOutputFiles);
            ++n2;
        }
        Parameters.reportLineFlush((String)"Finished Parsing.");
    }

    protected static ArrayList<String[]> getSentencesWords(ArrayList<TSNodeLabel> treebank) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (TSNodeLabel t : treebank) {
            ArrayList<TSNodeLabel> lex = t.collectLexicalItems();
            String[] sentenceWords = new String[lex.size()];
            int index = 0;
            for (TSNodeLabel l : lex) {
                String word;
                sentenceWords[index] = word = l.label();
                ++index;
            }
            result.add(sentenceWords);
        }
        return result;
    }

    private void submitMultithreadJob(BitParThreadRunner[] bitParThreadArray) {
        int i = 0;
        while (i < this.threads - 1) {
            BitParThreadRunner t = bitParThreadArray[i];
            t.start();
            ++i;
        }
        bitParThreadArray[this.threads - 1].run();
        i = 0;
        while (i < this.threads - 1) {
            try {
                bitParThreadArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            ++i;
        }
    }

    protected TSNodeLabel dealWithNOParsedSentences(String[] originalTestSentenceWords) {
        TSNodeLabel result = TSNodeLabel.defaultWSJparse(originalTestSentenceWords, this.topSymbol);
        Parameters.reportLineFlush((String)("No parse for sentence: " + Arrays.toString(originalTestSentenceWords) + "\n\t" + "Default parse: " + result));
        return result;
    }

    protected class BitParThreadRunner
    extends Thread {
        int threadIndex;
        int startSentenceIndex;
        ArrayList<String[]> flatSentencesForBitPar;
        ArrayList<String[]> originalTestSentencesWordsThread;
        MetricOptimizerArray metricOptimizer;

        public BitParThreadRunner(int threadIndex, int startSentenceIndex, ArrayList<String[]> testSentencesWordsThread, ArrayList<String[]> originalTestSentencesWordsThread) {
            this.threadIndex = threadIndex;
            this.startSentenceIndex = startSentenceIndex;
            this.flatSentencesForBitPar = testSentencesWordsThread;
            this.originalTestSentencesWordsThread = originalTestSentencesWordsThread;
            this.metricOptimizer = new MetricOptimizerArray();
        }

        @Override
        public void run() {
            Process p = null;
            try {
                p = Runtime.getRuntime().exec(BitParParserPetrov.this.bitparCommandAndArgs);
                BufferedWriter output = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                BufferedReader inputStd = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader inputErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                ReadInputStream inputStandardThread = new ReadInputStream(inputStd);
                ReadErrorStream inputErrorThread = new ReadErrorStream(inputErr);
                inputStandardThread.start();
                inputErrorThread.start();
                Iterator<String[]> iterator = this.flatSentencesForBitPar.iterator();
                while (iterator.hasNext()) {
                    String[] flatSentence;
                    String[] stringArray = flatSentence = iterator.next();
                    int n = flatSentence.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String word = stringArray[n2];
                        output.write(String.valueOf(word) + "\n");
                        ++n2;
                    }
                    output.write("\n");
                    output.flush();
                }
                output.write("\n");
                output.flush();
                output.close();
                inputStandardThread.join();
                inputErrorThread.join();
                inputStd.close();
                inputErr.close();
            }
            catch (Exception err) {
                err.printStackTrace();
                Parameters.reportLineFlush((String)err.getMessage());
                return;
            }
        }

        protected synchronized void doneWithOneSentence() {
            BitParParserPetrov.this.progress.next();
        }

        protected class ReadErrorStream
        extends Thread {
            BufferedReader input;
            String reportPrefix;
            int currentSentenceIndex;
            float parsingTime;
            int sentenceCounter;

            public ReadErrorStream(BufferedReader input) {
                this.currentSentenceIndex = BitParThreadRunner.this.startSentenceIndex;
                this.input = input;
                this.reportPrefix = "[stdOutErr_" + BitParThreadRunner.this.threadIndex + "]:";
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        if (line.equals("")) continue;
                        if (Character.isDigit(line.charAt(0))) {
                            BitParThreadRunner.this.doneWithOneSentence();
                            continue;
                        }
                        if (line.startsWith("reading") || line.startsWith("parameter") || line.startsWith("finished") || line.startsWith("raw")) continue;
                        Parameters.reportLineFlush((String)(String.valueOf(this.reportPrefix) + line));
                    }
                }
                catch (IOException err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush((String)err.getMessage());
                    return;
                }
            }
        }

        protected class ReadInputStream
        extends Thread {
            BufferedReader input;
            Iterator<String[]> originalTestIterator = null;
            String[] originalTestSentenceWords = null;
            double lastReadProb;
            int completedSentences;

            public ReadInputStream(BufferedReader input) {
                this.input = input;
                this.originalTestIterator = BitParThreadRunner.this.originalTestSentencesWordsThread.iterator();
                this.originalTestSentenceWords = this.originalTestIterator.next();
                BitParThreadRunner.this.metricOptimizer.prepareNextSentence(this.originalTestSentenceWords);
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.input.readLine()) != null) {
                        this.processLine(line);
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                    Parameters.reportLineFlush((String)err.getMessage());
                    return;
                }
            }

            private void processLine(String line) throws Exception {
                if (line.equals("")) {
                    BitParThreadRunner.this.metricOptimizer.storeCurrentBestParseTrees();
                    if (this.originalTestIterator.hasNext()) {
                        this.originalTestSentenceWords = this.originalTestIterator.next();
                        BitParThreadRunner.this.metricOptimizer.prepareNextSentence(this.originalTestSentenceWords);
                    }
                    return;
                }
                if (line.charAt(0) == '(') {
                    TSNodeLabel tree = null;
                    line = line.replaceAll("\\\\", "");
                    try {
                        tree = new TSNodeLabel(line);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    tree = CleanPetrov.cleanPetrovTree(tree);
                    BitParThreadRunner.this.metricOptimizer.addNewDerivation(tree, this.lastReadProb);
                    return;
                }
                if (line.startsWith(BitParParserPetrov.viterbProbPrefix)) {
                    this.lastReadProb = Double.parseDouble(line.substring(viterbProbPrefixLength));
                    return;
                }
                if (line.startsWith(BitParParserPetrov.noParseMessage)) {
                    TSNodeLabel tree = BitParParserPetrov.this.dealWithNOParsedSentences(this.originalTestSentenceWords);
                    BitParThreadRunner.this.metricOptimizer.addNewDerivation(tree, this.lastReadProb);
                    return;
                }
                Parameters.reportLineFlush((String)("Unknown line in bitpar output: " + line));
            }
        }
    }
}

