/*
 * Decompiled with CFR 0.152.
 */
package tsg.mb;

import java.util.ArrayList;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.mb.TreeMarkoBinarization;
import util.BoundedLinkedList;

public class TreeMarkoBinarizationRightStop_LC
extends TreeMarkoBinarization {
    static Label stopLabel = Label.getLabel("###STOP###");

    @Override
    public TSNodeLabel performMarkovBinarization(TSNodeLabel t) {
        TSNodeLabel result = TreeMarkoBinarizationRightStop_LC.performParentAnnotation(t);
        return this.performMarkoBinarizationRight(result);
    }

    @Override
    public TSNodeLabel undoMarkovBinarization(TSNodeLabel t) {
        TSNodeLabel result = this.undoMarkoBinarizationRight(t);
        return TreeMarkoBinarizationRightStop_LC.undoParentAnnotation(result);
    }

    private TSNodeLabel performMarkoBinarizationRight(TSNodeLabel t) {
        int prole = t.prole();
        TSNodeLabel binaryCopy = new TSNodeLabel(t.label, t.isLexical);
        if (prole == 0) {
            return binaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = this.performMarkoBinarizationRight(t.firstDaughter());
            binaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = binaryCopy;
            return binaryCopy;
        }
        BoundedLinkedList<String> lastSiblings = new BoundedLinkedList<String>(markH);
        String parentLabelString = String.valueOf(t.label()) + parentLabelSeparator;
        TSNodeLabel previousLevel = binaryCopy;
        int i = 0;
        while (i < prole) {
            TSNodeLabel d = t.daughters[i];
            lastSiblings.add(d.label());
            TSNodeLabel left = this.performMarkoBinarizationRight(d);
            StringBuilder rightLabelSB = new StringBuilder(parentLabelString);
            for (String s : lastSiblings.getList()) {
                rightLabelSB.append(catSeparationH);
                rightLabelSB.append(s);
            }
            Label rightLabel = Label.getLabel(rightLabelSB.toString());
            TSNodeLabel right = new TSNodeLabel(rightLabel, t.isLexical);
            previousLevel.assignDaughters(new TSNodeLabel[]{left, right});
            previousLevel = right;
            ++i;
        }
        TSNodeLabel stopNode = new TSNodeLabel(stopLabel, false);
        previousLevel.assignUniqueDaughter(stopNode);
        return binaryCopy;
    }

    private TSNodeLabel undoMarkoBinarizationRight(TSNodeLabel t) {
        int prole = t.prole();
        TSNodeLabel unbinaryCopy = new TSNodeLabel(t.label, t.isLexical);
        if (prole == 0) {
            return unbinaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = this.undoMarkoBinarizationRight(t.firstDaughter());
            unbinaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = unbinaryCopy;
            return unbinaryCopy;
        }
        ArrayList<TSNodeLabel> newDaughters = new ArrayList<TSNodeLabel>();
        TSNodeLabel currentLevel = t;
        do {
            TSNodeLabel firstDaughter = currentLevel.firstDaughter();
            if (firstDaughter.label == stopLabel) break;
            newDaughters.add(this.undoMarkoBinarizationRight(firstDaughter));
        } while ((currentLevel = currentLevel.lastDaughter()).label().indexOf(parentLabelSeparator) != -1);
        int newProle = newDaughters.size();
        unbinaryCopy.daughters = new TSNodeLabel[newProle];
        int i = 0;
        for (TSNodeLabel d : newDaughters) {
            unbinaryCopy.daughters[i++] = d;
            d.parent = unbinaryCopy;
        }
        return unbinaryCopy;
    }

    public static void main(String[] args) throws Exception {
        markH = 2;
        markV = 2;
        TSNodeLabel t = new TSNodeLabel("(A B C D E)");
        TSNodeLabel[] tSNodeLabelArray = t.daughters;
        int n = t.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.isLexical = false;
            ++n2;
        }
        System.out.println(t.toStringQtree());
        TreeMarkoBinarizationRightStop_LC tmb = new TreeMarkoBinarizationRightStop_LC();
        TSNodeLabel markoBinarizedTree = tmb.performMarkovBinarization(t);
        System.out.println(markoBinarizedTree.toStringQtree());
        System.out.println(markoBinarizedTree.checkParentDaughtersConsistency());
        System.out.println(markoBinarizedTree.checkOnlyAndAllTerminalsAreLexical());
        TSNodeLabel original = tmb.undoMarkovBinarization(markoBinarizedTree);
        System.out.println(original.toStringQtree());
        System.out.println(original.equals(t));
        System.out.println(original.checkParentDaughtersConsistency());
        System.out.println(original.checkOnlyAndAllTerminalsAreLexical());
    }
}

