/*
 * Decompiled with CFR 0.152.
 */
package tsg.mb;

import java.io.File;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.mb.TreeMarkoBinarization;
import util.BoundedLinkedList;
import util.FileUtil;
import wordModel.UkWordMapping;
import wordModel.UkWordMappingPetrov;

public class TreeMarkoBinarizationLeft_Petrov
extends TreeMarkoBinarization {
    @Override
    public TSNodeLabel performMarkovBinarization(TSNodeLabel t) {
        TSNodeLabel result = TreeMarkoBinarizationLeft_Petrov.performParentAnnotation(t);
        return this.performMarkoBinarizationLeft(result);
    }

    @Override
    public TSNodeLabel undoMarkovBinarization(TSNodeLabel t) {
        TSNodeLabel result = this.undoMarkoBinarizationLeft(t);
        return TreeMarkoBinarizationLeft_Petrov.undoParentAnnotation(result);
    }

    private TSNodeLabel performMarkoBinarizationLeft(TSNodeLabel t) {
        int prole = t.prole();
        TSNodeLabel binaryCopy = new TSNodeLabel(t.label, t.isLexical);
        if (prole == 0) {
            return binaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = this.performMarkoBinarizationLeft(t.firstDaughter());
            binaryCopy.assignUniqueDaughter(onlyDaughter);
            return binaryCopy;
        }
        if (prole == 2) {
            TSNodeLabel firstDaughter = this.performMarkoBinarizationLeft(t.daughters[0]);
            TSNodeLabel secondDaughter = this.performMarkoBinarizationLeft(t.daughters[1]);
            binaryCopy.assignDaughters(new TSNodeLabel[]{firstDaughter, secondDaughter});
            return binaryCopy;
        }
        BoundedLinkedList<String> lastSiblings = new BoundedLinkedList<String>(markH);
        String parentLabelString = t.label();
        TSNodeLabel firstDaughter = this.performMarkoBinarizationLeft(t.daughters[0]);
        TSNodeLabel secondDaughter = this.performMarkoBinarizationLeft(t.daughters[1]);
        lastSiblings.add(firstDaughter.label());
        lastSiblings.add(secondDaughter.label());
        Label firstLevelLabel = TreeMarkoBinarization.buildArtificialLabel(parentLabelString, lastSiblings);
        TSNodeLabel previousLevel = new TSNodeLabel(firstLevelLabel, false);
        previousLevel.assignDaughters(new TSNodeLabel[]{firstDaughter, secondDaughter});
        int i = 2;
        while (i < prole - 1) {
            TSNodeLabel d = t.daughters[i];
            TSNodeLabel right = this.performMarkoBinarizationLeft(d);
            lastSiblings.add(d.label());
            Label newLevelLabel = TreeMarkoBinarization.buildArtificialLabel(parentLabelString, lastSiblings);
            TSNodeLabel newLevel = new TSNodeLabel(newLevelLabel, t.isLexical);
            newLevel.assignDaughters(new TSNodeLabel[]{previousLevel, right});
            previousLevel = newLevel;
            ++i;
        }
        TSNodeLabel lastDaughter = this.performMarkoBinarizationLeft(t.daughters[prole - 1]);
        binaryCopy.assignDaughters(new TSNodeLabel[]{previousLevel, lastDaughter});
        return binaryCopy;
    }

    private TSNodeLabel undoMarkoBinarizationLeft(TSNodeLabel t) {
        int prole = t.prole();
        TSNodeLabel unbinaryCopy = new TSNodeLabel(t.label, t.isLexical);
        if (prole == 0) {
            return unbinaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = this.undoMarkoBinarizationLeft(t.firstDaughter());
            unbinaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = unbinaryCopy;
            return unbinaryCopy;
        }
        ArrayList<TSNodeLabel> newDaughters = new ArrayList<TSNodeLabel>();
        TSNodeLabel currentLevel = t;
        do {
            newDaughters.add(this.undoMarkoBinarizationLeft(currentLevel.lastDaughter()));
        } while (TreeMarkoBinarizationLeft_Petrov.isArtificialNode(currentLevel = currentLevel.daughters[0]));
        newDaughters.add(this.undoMarkoBinarizationLeft(currentLevel));
        int newProle = newDaughters.size();
        unbinaryCopy.daughters = new TSNodeLabel[newProle];
        int i = newProle - 1;
        for (TSNodeLabel d : newDaughters) {
            unbinaryCopy.daughters[i--] = d;
            d.parent = unbinaryCopy;
        }
        return unbinaryCopy;
    }

    public static void main1(String[] args) throws Exception {
        markH = 1;
        markV = 2;
        TreeMarkoBinarizationLeft_Petrov tmb = new TreeMarkoBinarizationLeft_Petrov();
        TSNodeLabel tree = new TSNodeLabel("(VP|S VBD|VP (NP|VP (NP|NP DT|NP NN|NP) (PP|NP (IN|PP \"with\") NP|PP)))", false);
        System.out.println(tree.toStringQtree());
        TSNodeLabel clean = tmb.undoMarkovBinarization(tree);
        System.out.println(clean.toStringQtree());
    }

    public static void main3(String[] args) throws Exception {
        markH = 1;
        markV = 2;
        TSNodeLabel t = TSNodeLabel.getRandomTree(new String[]{"A", "B", "C", "D", "E", "F", "G"}, new String[]{"a", "b", "c", "d", "e", "f", "g"}, 5, new double[]{0.2, 0.2, 0.2, 0.2, 0.2}, true, 0.2, 2, 5);
        System.out.println(t.toStringQtree());
        TreeMarkoBinarizationLeft_Petrov tmb = new TreeMarkoBinarizationLeft_Petrov();
        TSNodeLabel markoBinarizedTree = tmb.performMarkovBinarization(t);
        System.out.println(markoBinarizedTree.toStringQtree());
        BigInteger fragmnetsOriginal = t.countTotalFragments()[0];
        BigInteger fragmnetsBinarized = markoBinarizedTree.countTotalFragments()[0];
        System.out.println(fragmnetsOriginal);
        System.out.println(fragmnetsBinarized);
    }

    public static void main(String[] args) throws Exception {
        File trainingTreebankFile = new File(args[0]);
        File testTreebankFile = new File(args[1]);
        File outputTrainingTreebankFile = new File(args[2]);
        File outputTestTreebankFile = new File(args[3]);
        markH = Integer.parseInt(args[4]);
        markV = Integer.parseInt(args[5]);
        UkWordMapping.ukThreashold = Integer.parseInt(args[6]);
        ArrayList trainingTreebank = TSNodeLabel.getTreebank(trainingTreebankFile);
        ArrayList testTreebank = TSNodeLabel.getTreebank(testTreebankFile);
        if (UkWordMapping.ukThreashold > 0) {
            UkWordMappingPetrov ukModel = new UkWordMappingPetrov();
            ukModel.init(trainingTreebank, testTreebank);
            trainingTreebank = ukModel.transformTrainingTreebank();
            testTreebank = ukModel.transformTestTreebank();
        }
        TreeMarkoBinarizationLeft_Petrov.transformTreebank(trainingTreebank, outputTrainingTreebankFile);
        TreeMarkoBinarizationLeft_Petrov.transformTreebank(testTreebank, outputTestTreebankFile);
    }

    private static void transformTreebank(ArrayList<TSNodeLabel> treebank, File ouputFile) {
        PrintWriter pw = FileUtil.getPrintWriter(ouputFile);
        TreeMarkoBinarizationLeft_Petrov treeMarkovBinarizer = new TreeMarkoBinarizationLeft_Petrov();
        for (TSNodeLabel t : treebank) {
            TSNodeLabel transformed = ((TreeMarkoBinarization)treeMarkovBinarizer).performMarkovBinarization(t);
            pw.println(transformed.toString());
        }
        pw.close();
    }
}

