/*
 * Decompiled with CFR 0.152.
 */
package tsg.mb;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.mb.TreeMarkoBinarizationLeft_LC;
import util.ArgumentReader;
import util.BoundedLinkedList;
import util.FileUtil;

public abstract class TreeMarkoBinarization {
    static char artificialNodesBracketsStart = (char)60;
    static char artificialNodesBracketsEnd = (char)62;
    public static String parentLabelSeparator = "@";
    static char catSeparationV = (char)124;
    static char catSeparationH = (char)95;
    static char headSeparation = (char)35;
    public static int markH = 2;
    public static int markV = 2;

    public static void setHV(int h, int v) {
        markH = h;
        markV = v;
    }

    public ArrayList<TSNodeLabel> markoBinarizeTreebank(ArrayList<TSNodeLabel> treebank) {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>(treebank.size());
        for (TSNodeLabel t : treebank) {
            result.add(this.performMarkovBinarization(t));
        }
        return result;
    }

    public abstract TSNodeLabel performMarkovBinarization(TSNodeLabel var1);

    public abstract TSNodeLabel undoMarkovBinarization(TSNodeLabel var1);

    public static TSNodeLabel performParentAnnotation(TSNodeLabel t) {
        if (markV <= 1) {
            return t;
        }
        return TreeMarkoBinarization.performRealParentAnnotation(t);
    }

    private static TSNodeLabel performRealParentAnnotation(TSNodeLabel t) {
        if (t.isLexical) {
            return new TSNodeLabel(t.label, true);
        }
        Label resultLabel = null;
        if (t.parent == null) {
            resultLabel = t.label;
        } else {
            StringBuilder newLabelSB = new StringBuilder();
            TSNodeLabel parent = t.parent;
            int i = 1;
            while (i < markV) {
                String prependString = String.valueOf(catSeparationV) + parent.label();
                newLabelSB.insert(0, prependString);
                parent = parent.parent;
                if (parent == null) break;
                ++i;
            }
            newLabelSB.insert(0, t.label());
            resultLabel = Label.getLabel(newLabelSB.toString());
        }
        TSNodeLabel result = new TSNodeLabel(resultLabel, false);
        int prole = t.prole();
        TSNodeLabel[] newDaughters = new TSNodeLabel[prole];
        result.daughters = newDaughters;
        if (!t.isTerminal()) {
            int i = 0;
            while (i < prole) {
                TSNodeLabel d;
                newDaughters[i] = d = TreeMarkoBinarization.performRealParentAnnotation(t.daughters[i]);
                d.parent = result;
                ++i;
            }
        }
        return result;
    }

    public static TSNodeLabel undoParentAnnotation(TSNodeLabel t) {
        if (markV <= 1) {
            return t;
        }
        return TreeMarkoBinarization.undoParentAnnotationReal(t);
    }

    private static TSNodeLabel undoParentAnnotationReal(TSNodeLabel t) {
        if (t.isLexical) {
            return new TSNodeLabel(t.label, true);
        }
        String labelString = t.label();
        int index = labelString.indexOf(catSeparationV);
        Label newLabel = index == -1 ? t.label : Label.getLabel(labelString.substring(0, index));
        TSNodeLabel result = new TSNodeLabel(newLabel, false);
        if (!t.isTerminal()) {
            int prole = t.prole();
            TSNodeLabel[] newDaughters = new TSNodeLabel[prole];
            result.daughters = newDaughters;
            int i = 0;
            while (i < prole) {
                TSNodeLabel d;
                newDaughters[i] = d = TreeMarkoBinarization.undoParentAnnotationReal(t.daughters[i]);
                d.parent = result;
                ++i;
            }
        }
        return result;
    }

    public static Label buildArtificialLabel(String parentLabel, BoundedLinkedList<String> previousSiblings) {
        StringBuilder sb = new StringBuilder(parentLabel);
        sb.append(parentLabelSeparator);
        for (String s : previousSiblings.getList()) {
            sb.append(catSeparationH);
            sb.append(s);
        }
        return Label.getLabel(sb.toString());
    }

    public static boolean isArtificialNode(TSNodeLabel t) {
        return t.label().indexOf(parentLabelSeparator) != -1;
    }

    public static void main1(String[] args) throws Exception {
        markV = 3;
        TSNodeLabel t = new TSNodeLabel("(A B (C F G H) (D I) (E (J K L)))");
        System.out.println(t);
        TSNodeLabel parentAnnotatedTree = TreeMarkoBinarization.performParentAnnotation(t);
        System.out.println(parentAnnotatedTree);
        System.out.println(parentAnnotatedTree.checkParentDaughtersConsistency());
        System.out.println(parentAnnotatedTree.checkOnlyAndAllTerminalsAreLexical());
        TSNodeLabel original = TreeMarkoBinarization.undoParentAnnotation(parentAnnotatedTree);
        System.out.println(original);
        System.out.println(original.equals(t));
        System.out.println(original.checkParentDaughtersConsistency());
        System.out.println(original.checkOnlyAndAllTerminalsAreLexical());
    }

    public static void main(String[] args) throws Exception {
        String markovH = "-markovH:";
        String markovV = "-markovV:";
        markH = 1;
        markV = 2;
        String usage = "USAGE: java [-Xmx1G] TreeMarkoBinarization[-markovH:2] [-markovV:2] inputFile outputFile";
        if (args.length < 2 || args.length > 4) {
            System.err.println("Incorrect number of arguments: " + args.length);
            System.err.println(usage);
            System.exit(-1);
        }
        int i = 0;
        while (i < args.length - 2) {
            String option;
            if ((option = args[i++]).startsWith(markovH)) {
                markH = ArgumentReader.readIntOption(option);
                continue;
            }
            if (!option.startsWith(markovV)) continue;
            markV = ArgumentReader.readIntOption(option);
        }
        File inputFile = new File(args[i++]);
        File outputFile = new File(args[i]);
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(inputFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        TreeMarkoBinarizationLeft_LC treeMarkovBinarizer = new TreeMarkoBinarizationLeft_LC();
        for (TSNodeLabel t : treebank) {
            TSNodeLabel transformed = ((TreeMarkoBinarization)treeMarkovBinarizer).performMarkovBinarization(t);
            pw.println(transformed.toString());
        }
        pw.close();
    }
}

