/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.corpora.Wsj;
import util.FileUtil;
import util.PrintProgress;
import util.Utility;

public class UncoveredFragmentsExtractor
extends Thread {
    ArrayList<TSNodeLabel> treebank;
    Iterator<TSNodeLabel> treebankIterator;
    File fragmentsFile;
    File outputFile;
    ArrayList<TSNodeLabel> fragmentsList;
    int threads;
    PrintProgress progress;
    Hashtable<String, int[]> unseenFragmentsTable;

    public UncoveredFragmentsExtractor(File treebankFile, File fragmentsFile, File outputFile, int threads) throws Exception {
        this(Wsj.getTreebank(treebankFile), fragmentsFile, outputFile, threads);
    }

    public UncoveredFragmentsExtractor(ArrayList<TSNodeLabel> treebank, File fragmentsFile, File outputFile, int threads) {
        this.treebank = treebank;
        this.fragmentsFile = fragmentsFile;
        this.outputFile = outputFile;
        this.threads = threads;
        this.treebankIterator = treebank.iterator();
        this.unseenFragmentsTable = new Hashtable();
    }

    @Override
    public void run() {
        this.extractUnseenFragments();
    }

    private void extractUnseenFragments() {
        this.fragmentsList = new ArrayList();
        Scanner fragmentScan = FileUtil.getScanner(this.fragmentsFile);
        while (fragmentScan.hasNextLine()) {
            String line = fragmentScan.nextLine();
            String[] treeFreq = line.split("\t");
            String fragment = treeFreq[0];
            try {
                this.fragmentsList.add(new TSNodeLabel(fragment, false));
            }
            catch (Exception e) {
                e.printStackTrace();
                Parameters.reportError((String)("Problems in fragmentsFile: " + line));
                Parameters.reportError((String)e.getMessage());
                return;
            }
        }
        Parameters.reportLineFlush((String)"Extracting unseen fragments from treebank.");
        Parameters.reportLineFlush((String)("Total trees in treebank: " + this.treebank.size()));
        this.progress = new PrintProgress("Extracting from tree:", 100, 0);
        this.extractUnseenFragmentsWithThreads();
        this.progress.end();
        PrintWriter unseenFragmentsPW = FileUtil.getPrintWriter(this.outputFile);
        for (Map.Entry<String, int[]> e : this.unseenFragmentsTable.entrySet()) {
            String newLine = String.valueOf(e.getKey()) + "\t" + e.getValue()[0];
            unseenFragmentsPW.println(newLine);
        }
        unseenFragmentsPW.close();
    }

    private void extractUnseenFragmentsWithThreads() {
        FragmentsExtractorThread[] threadsArray = new FragmentsExtractorThread[this.threads];
        int i = 0;
        while (i < this.threads) {
            threadsArray[i] = new FragmentsExtractorThread();
            ++i;
        }
        int lastThreadIndex = this.threads - 1;
        int i2 = 0;
        while (i2 < lastThreadIndex) {
            threadsArray[i2].start();
            ++i2;
        }
        threadsArray[lastThreadIndex].run();
        i2 = 0;
        while (i2 < lastThreadIndex) {
            try {
                threadsArray[i2].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i2;
        }
    }

    private synchronized TSNodeLabel getNextTree() {
        if (!this.treebankIterator.hasNext()) {
            return null;
        }
        this.progress.next();
        return this.treebankIterator.next();
    }

    private synchronized void addFragmentInTable(String fragmentLine) {
        Utility.increaseInTableInt(this.unseenFragmentsTable, fragmentLine);
    }

    private static void setCoveredNodes(TSNodeLabelIndex t, TSNodeLabel fragment, BitSet coveredNodesSet) {
        BitSet fragmentSet = new BitSet();
        if (t.sameLabelAndDaughersLabels(fragment) && UncoveredFragmentsExtractor.setCoveredNodesNonRecursive(t, fragment, fragmentSet)) {
            coveredNodesSet.or(fragmentSet);
        }
        TSNodeLabel[] tSNodeLabelArray = t.daughters;
        int n = t.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            TSNodeLabelIndex di = (TSNodeLabelIndex)d;
            if (!di.isLexical) {
                UncoveredFragmentsExtractor.setCoveredNodes(di, fragment, coveredNodesSet);
            }
            ++n2;
        }
    }

    private static boolean setCoveredNodesNonRecursive(TSNodeLabelIndex t, TSNodeLabel fragment, BitSet set) {
        set.set(t.index);
        int treeProle = t.prole();
        int i = 0;
        while (i < treeProle) {
            TSNodeLabelIndex treeDaughterIndex = (TSNodeLabelIndex)t.daughters[i];
            TSNodeLabel fragmentDaughter = fragment.daughters[i];
            if (treeDaughterIndex.isLexical || fragmentDaughter.isTerminal()) {
                if (!treeDaughterIndex.sameLabel(fragmentDaughter)) {
                    return false;
                }
            } else {
                if (!treeDaughterIndex.sameLabelAndDaughersLabels(fragmentDaughter)) {
                    return false;
                }
                if (!UncoveredFragmentsExtractor.setCoveredNodesNonRecursive(treeDaughterIndex, fragmentDaughter, set)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static TSNodeLabel getSubTreeAndInternalFrontiers(TSNodeLabelIndex thisNode, BitSet coveredNodesSet, ArrayList<TSNodeLabelIndex> frontiers) {
        TSNodeLabel result = thisNode.nonRecursiveCopy();
        if (thisNode.isLexical) {
            return result;
        }
        result.daughters = new TSNodeLabel[thisNode.daughters.length];
        int i = 0;
        while (i < thisNode.daughters.length) {
            TSNodeLabelIndex dNodeIndex = (TSNodeLabelIndex)thisNode.daughters[i];
            TSNodeLabel dSubTree = null;
            if (dNodeIndex.isLexical || !coveredNodesSet.get(dNodeIndex.index)) {
                dSubTree = UncoveredFragmentsExtractor.getSubTreeAndInternalFrontiers(dNodeIndex, coveredNodesSet, frontiers);
            } else {
                if (!dNodeIndex.isPreLexical()) {
                    frontiers.add(dNodeIndex);
                }
                dSubTree = dNodeIndex.nonRecursiveCopy();
            }
            dSubTree.parent = result;
            result.daughters[i] = dSubTree;
            ++i;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        File treebankFile = new File(args[0]);
        File fragmentsFile = new File(args[1]);
        File outputFile = new File(args[2]);
        int threads = Integer.parseInt(args[3]);
        Parameters.reportLineFlush((String)("Collecting Uncovered Fragments in " + outputFile));
        new UncoveredFragmentsExtractor(treebankFile, fragmentsFile, outputFile, threads).run();
    }

    protected class FragmentsExtractorThread
    extends Thread {
        protected FragmentsExtractorThread() {
        }

        @Override
        public void run() {
            TSNodeLabel t = null;
            while ((t = UncoveredFragmentsExtractor.this.getNextTree()) != null) {
                this.getUncoveredFragments(t);
            }
        }

        private void getUncoveredFragments(TSNodeLabel t) {
            TSNodeLabelIndex treeIndex = new TSNodeLabelIndex(t);
            int totalNodes = treeIndex.countAllNodes();
            BitSet coveredNodesSet = new BitSet();
            boolean allCovered = false;
            for (TSNodeLabel fragment : UncoveredFragmentsExtractor.this.fragmentsList) {
                UncoveredFragmentsExtractor.setCoveredNodes(treeIndex, fragment, coveredNodesSet);
                if (coveredNodesSet.cardinality() != totalNodes) continue;
                allCovered = true;
                break;
            }
            if (allCovered) {
                return;
            }
            this.printUncoveredFragmentsRecursive(treeIndex, coveredNodesSet);
        }

        private void printUncoveredFragmentsRecursive(TSNodeLabelIndex treeIndex, BitSet coveredNodesSet) {
            if (!coveredNodesSet.get(treeIndex.index)) {
                if (treeIndex.isPreLexical()) {
                    UncoveredFragmentsExtractor.this.addFragmentInTable(treeIndex.toString(false, true));
                    return;
                }
                ArrayList<TSNodeLabelIndex> nonLexicalFroniers = new ArrayList<TSNodeLabelIndex>();
                TSNodeLabel subTree = UncoveredFragmentsExtractor.getSubTreeAndInternalFrontiers(treeIndex, coveredNodesSet, nonLexicalFroniers);
                UncoveredFragmentsExtractor.this.addFragmentInTable(subTree.toString(false, true));
                Iterator<TSNodeLabelIndex> iterator = nonLexicalFroniers.iterator();
                while (iterator.hasNext()) {
                    TSNodeLabelIndex f;
                    TSNodeLabelIndex fNodeIndex = f = iterator.next();
                    this.printUncoveredFragmentsRecursive(fNodeIndex, coveredNodesSet);
                }
                return;
            }
            if (treeIndex.isPreLexical()) {
                return;
            }
            TSNodeLabel[] tSNodeLabelArray = treeIndex.daughters;
            int n = treeIndex.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel d = tSNodeLabelArray[n2];
                TSNodeLabelIndex dNodeIndex = (TSNodeLabelIndex)d;
                this.printUncoveredFragmentsRecursive(dNodeIndex, coveredNodesSet);
                ++n2;
            }
        }
    }
}

