/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import settings.Parameters;
import util.FileUtil;
import util.PrintProgress;

public class SortAndMergeFragmentFilesBz {
    PrintProgress progress;
    public static int numberOfFilesPerMergePass = 1000;

    public SortAndMergeFragmentFilesBz(File fileDir, File outputFile, String unsortedFilePrefix, String sortedFilePrefix, String tmpFilePrefix) {
        String outputPath = String.valueOf(fileDir.getAbsolutePath()) + "/";
        Object[] fileList = fileDir.listFiles();
        Arrays.sort(fileList);
        Vector<Object> ouputSortedFile = new Vector<Object>();
        File mergingDoneFile = new File(String.valueOf(outputPath) + "/.mergingDone");
        if (mergingDoneFile.exists()) {
            System.out.println("Merged file already exists!");
            return;
        }
        this.progress = new PrintProgress("Sorting File ");
        Object[] objectArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            Object inputFile = objectArray[n2];
            this.progress.next();
            String fileName = ((File)inputFile).getName();
            if (fileName.startsWith(sortedFilePrefix)) {
                ouputSortedFile.add(inputFile);
            } else if (fileName.startsWith(unsortedFilePrefix)) {
                File sortedFile = new File(String.valueOf(outputPath) + sortedFilePrefix + fileName);
                File sortedFileTmp = new File(String.valueOf(outputPath) + tmpFilePrefix + sortedFilePrefix + fileName);
                SortAndMergeFragmentFilesBz.sortFile((File)inputFile, sortedFileTmp, sortedFile);
                ouputSortedFile.add(sortedFile);
            }
            ++n2;
        }
        this.progress.end();
        Object[] ouputSortedFileArray = ouputSortedFile.toArray(new File[0]);
        Arrays.sort(ouputSortedFileArray);
        Parameters.reportLineFlush((String)"Merging Files.");
        SortAndMergeFragmentFilesBz.mergeSortedFiles((File[])ouputSortedFileArray, outputFile, outputPath);
        FileUtil.appendReturn("merging done!", mergingDoneFile);
    }

    private static void sortFile(File inputFile, File outputFileTmp, File outputFile) {
        ArrayList<String> linesToSort = new ArrayList<String>();
        try {
            BufferedReader gzipReader = new BufferedReader(new InputStreamReader((InputStream)new CBZip2InputStream((InputStream)new FileInputStream(inputFile)), "UTF-8"));
            String line = null;
            while ((line = gzipReader.readLine()) != null) {
                linesToSort.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collections.sort(linesToSort);
        try {
            FileOutputStream fileStream = new FileOutputStream(outputFileTmp);
            BufferedWriter gzipWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new CBZip2OutputStream((OutputStream)fileStream), "UTF-8"));
            for (String line : linesToSort) {
                gzipWriter.write(String.valueOf(line) + "\n");
            }
            gzipWriter.close();
            fileStream.close();
        }
        catch (Exception e) {
            System.err.println("Problems while writing bzip2 file");
            e.printStackTrace();
            return;
        }
        outputFileTmp.renameTo(outputFile);
        inputFile.delete();
    }

    private static BufferedReader[] getFileReaders(File[] sortedFiles) {
        int filesNumber = sortedFiles.length;
        BufferedReader[] result = new BufferedReader[filesNumber];
        try {
            int i = 0;
            while (i < filesNumber) {
                File f = sortedFiles[i];
                result[i] = new BufferedReader(new InputStreamReader((InputStream)new CBZip2InputStream((InputStream)new FileInputStream(f)), "UTF-8"));
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String readNextLine(BufferedReader reader) {
        String result = null;
        try {
            result = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void mergeSortedFiles(File[] sortedFiles, File outputFile, String outputPath) {
        int numberOfFiles = sortedFiles.length;
        if (numberOfFiles <= numberOfFilesPerMergePass) {
            SortAndMergeFragmentFilesBz.mergeSortedFilesSinglePass(sortedFiles, outputFile);
        } else {
            SortAndMergeFragmentFilesBz.mergeSortedFilesMultiPass(sortedFiles, outputFile, outputPath);
        }
    }

    private static void mergeSortedFilesSinglePass(File[] sortedFiles, File outputFile) {
        PrintWriter ouputWriter = FileUtil.getPrintWriter(outputFile);
        int filesNumber = sortedFiles.length;
        BufferedReader[] filesReaders = SortAndMergeFragmentFilesBz.getFileReaders(sortedFiles);
        TreeSet<FragmentFreqFileIndex> queue = new TreeSet<FragmentFreqFileIndex>();
        int i = 0;
        while (i < filesNumber) {
            FragmentFreqFileIndex fileLine = new FragmentFreqFileIndex(SortAndMergeFragmentFilesBz.readNextLine(filesReaders[i]), i);
            queue.add(fileLine);
            ++i;
        }
        FragmentFreqFileIndex pendingFragment = (FragmentFreqFileIndex)queue.pollFirst();
        int fileIndex = pendingFragment.fileIndex;
        FragmentFreqFileIndex fileLine = new FragmentFreqFileIndex(SortAndMergeFragmentFilesBz.readNextLine(filesReaders[fileIndex]), fileIndex);
        queue.add(fileLine);
        do {
            FragmentFreqFileIndex topOfTheQueue = (FragmentFreqFileIndex)queue.pollFirst();
            fileIndex = topOfTheQueue.fileIndex;
            String nextLine = SortAndMergeFragmentFilesBz.readNextLine(filesReaders[fileIndex]);
            if (nextLine != null) {
                fileLine = new FragmentFreqFileIndex(nextLine, fileIndex);
                queue.add(fileLine);
            }
            if (topOfTheQueue.sameFragment(pendingFragment)) {
                pendingFragment.freq += topOfTheQueue.freq;
                continue;
            }
            ouputWriter.println(String.valueOf(pendingFragment.fragment) + "\t" + pendingFragment.freq);
            pendingFragment = topOfTheQueue;
        } while (!queue.isEmpty());
        ouputWriter.println(String.valueOf(pendingFragment.fragment) + "\t" + pendingFragment.freq);
        ouputWriter.close();
    }

    private static void mergeSortedFilesSinglePassCompressed(File[] sortedFiles, File outputFile) throws UnsupportedEncodingException, IOException {
        FileOutputStream fileStream = new FileOutputStream(outputFile);
        BufferedWriter gzipWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new CBZip2OutputStream((OutputStream)fileStream), "UTF-8"));
        int filesNumber = sortedFiles.length;
        BufferedReader[] filesReaders = SortAndMergeFragmentFilesBz.getFileReaders(sortedFiles);
        TreeSet<FragmentFreqFileIndex> queue = new TreeSet<FragmentFreqFileIndex>();
        int i = 0;
        while (i < filesNumber) {
            FragmentFreqFileIndex fileLine = new FragmentFreqFileIndex(SortAndMergeFragmentFilesBz.readNextLine(filesReaders[i]), i);
            queue.add(fileLine);
            ++i;
        }
        FragmentFreqFileIndex pendingFragment = (FragmentFreqFileIndex)queue.pollFirst();
        int fileIndex = pendingFragment.fileIndex;
        FragmentFreqFileIndex fileLine = new FragmentFreqFileIndex(SortAndMergeFragmentFilesBz.readNextLine(filesReaders[fileIndex]), fileIndex);
        queue.add(fileLine);
        do {
            FragmentFreqFileIndex topOfTheQueue = (FragmentFreqFileIndex)queue.pollFirst();
            fileIndex = topOfTheQueue.fileIndex;
            String nextLine = SortAndMergeFragmentFilesBz.readNextLine(filesReaders[fileIndex]);
            if (nextLine != null) {
                fileLine = new FragmentFreqFileIndex(nextLine, fileIndex);
                queue.add(fileLine);
            }
            if (topOfTheQueue.sameFragment(pendingFragment)) {
                pendingFragment.freq += topOfTheQueue.freq;
                continue;
            }
            gzipWriter.write(String.valueOf(pendingFragment.fragment) + "\t" + pendingFragment.freq + "\n");
            pendingFragment = topOfTheQueue;
        } while (!queue.isEmpty());
        gzipWriter.close();
        fileStream.close();
    }

    private static void mergeSortedFilesMultiPass(File[] sortedFiles, File outputFile, String outputPath) {
        int filesNumber = sortedFiles.length;
        int numberOfPasses = filesNumber / numberOfFilesPerMergePass;
        int filesInLast = filesNumber % numberOfFilesPerMergePass;
        if (filesInLast > 0) {
            ++numberOfPasses;
        } else {
            filesInLast = numberOfFilesPerMergePass;
        }
        File[] outputFilesPasses = new File[numberOfPasses];
        int pass = 1;
        while (pass <= numberOfPasses) {
            File currentOutputFilePass;
            int filesInCurrentPass = pass == numberOfPasses ? filesInLast : numberOfFilesPerMergePass;
            outputFilesPasses[pass - 1] = currentOutputFilePass = new File(String.valueOf(outputPath) + "tmp_pass_" + pass + ".bz2");
            File[] sortedFilesPass = new File[filesInCurrentPass];
            int j = (pass - 1) * numberOfFilesPerMergePass;
            int i = 0;
            while (i < filesInCurrentPass) {
                sortedFilesPass[i] = sortedFiles[j];
                ++j;
                ++i;
            }
            try {
                SortAndMergeFragmentFilesBz.mergeSortedFilesSinglePassCompressed(sortedFilesPass, currentOutputFilePass);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            Parameters.reportLineFlush((String)("First pass done " + currentOutputFilePass));
            ++pass;
        }
        SortAndMergeFragmentFilesBz.mergeSortedFilesSinglePass(outputFilesPasses, outputFile);
    }

    public static void main1(String[] args) {
        File dir = new File(args[0]);
        File outputFile = new File(args[1]);
        File[] fileList = dir.listFiles();
        Vector<File> bzFileList = new Vector<File>();
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            File f = fileArray[n2];
            if (!f.isDirectory() && !(name = f.getName()).startsWith(".") && name.endsWith("bz2")) {
                bzFileList.add(f);
            }
            ++n2;
        }
        fileList = bzFileList.toArray(new File[0]);
        int size = fileList.length;
        System.out.println("Uncompressing " + size + " .bz2 files to " + outputFile);
        SortAndMergeFragmentFilesBz.mergeSortedFilesSinglePass(fileList, outputFile);
    }

    private static void printAlphabet(BufferedWriter writer, int maxChar, int iter) throws IOException {
        char[] alpha = new char[maxChar];
        char[] beta = new char[maxChar];
        int i = 0;
        while (i < maxChar) {
            alpha[i] = (char)i;
            ++i;
        }
        i = maxChar - 1;
        while (i >= 0) {
            beta[i] = (char)i;
            --i;
        }
        String a = String.copyValueOf(alpha);
        String b = String.copyValueOf(beta);
        int i2 = 0;
        while (i2 < iter) {
            writer.write(String.valueOf(a) + "\n");
            writer.write(String.valueOf(b) + "\n");
            ++i2;
        }
    }

    public static void main(String[] args) throws IOException {
        File outputFile = new File("tmp/testCompression.txt");
        File outputFileCompressed = new File("tmp/testCompression_Java.txt.bz");
        File outputFileCompressedUTF8 = new File("tmp/testCompression_Java_utf8.txt.bz");
        FileOutputStream fileStreamCompressed = new FileOutputStream(outputFileCompressed);
        FileOutputStream fileStreamCompressedUTF8 = new FileOutputStream(outputFileCompressedUTF8);
        FileOutputStream fileStream = new FileOutputStream(outputFile);
        BufferedWriter gzipWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new CBZip2OutputStream((OutputStream)fileStreamCompressed)));
        BufferedWriter gzipWriterUTF8 = new BufferedWriter(new OutputStreamWriter((OutputStream)new CBZip2OutputStream((OutputStream)fileStreamCompressedUTF8), "UTF-8"));
        BufferedWriter normWriter = new BufferedWriter(new FileWriter(outputFile));
        int maxChar = 500;
        int iter = 100;
        SortAndMergeFragmentFilesBz.printAlphabet(gzipWriter, maxChar, iter);
        SortAndMergeFragmentFilesBz.printAlphabet(gzipWriterUTF8, maxChar, iter);
        SortAndMergeFragmentFilesBz.printAlphabet(normWriter, maxChar, iter);
        gzipWriter.close();
        gzipWriterUTF8.close();
        normWriter.close();
        fileStreamCompressed.close();
        fileStreamCompressedUTF8.close();
        fileStream.close();
    }

    private static class FragmentFreqFileIndex
    implements Comparable<FragmentFreqFileIndex> {
        String fragment;
        int freq;
        int fileIndex;

        public FragmentFreqFileIndex(String line, int fileIndex) {
            String[] treeFreq = line.split("\t");
            this.fragment = treeFreq[0];
            this.freq = Integer.parseInt(treeFreq[1]);
            this.fileIndex = fileIndex;
        }

        @Override
        public int compareTo(FragmentFreqFileIndex o) {
            int cmp = this.fragment.compareTo(o.fragment);
            if (cmp != 0) {
                return cmp;
            }
            cmp = new Integer(this.freq).compareTo(new Integer(o.freq));
            if (cmp != 0) {
                return cmp;
            }
            return new Integer(this.fileIndex).compareTo(new Integer(o.fileIndex));
        }

        public boolean equals(Object o) {
            if (o instanceof FragmentFreqFileIndex) {
                FragmentFreqFileIndex otherLineFileIndex = (FragmentFreqFileIndex)o;
                return this.fragment.equals(otherLineFileIndex.fragment) && this.freq == otherLineFileIndex.freq && this.fileIndex == otherLineFileIndex.fileIndex;
            }
            return false;
        }

        public boolean sameFragment(FragmentFreqFileIndex o) {
            return this.fragment.equals(o.fragment);
        }
    }
}

