/*
 * Decompiled with CFR 0.152.
 */
package tsg.LTSG;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import settings.Parameters;
import tsg.LTSG.LTSG;
import tsg.TSNode;
import util.FileUtil;
import util.PrintProgressStatic;
import util.Utility;

public class LTSG_Greedy
extends LTSG {
    public static final String GreedyTop = "GreedyTop";
    public static final String GreedyBottom = "GreedyBottom";
    private static final boolean traceAmbiguity = true;
    private int totalHeadChoices;
    private int ambiguousHeadChoices;
    private int secondTotalHeadChoices;
    private File ambiguityReportFile = new File(String.valueOf(Parameters.outputPath) + "AmbiguityReport.txt");
    private File ambiguityCategoryFile = new File(String.valueOf(Parameters.outputPath) + "AmbiguityCategory.txt");
    private PrintWriter ambiguityWriter = FileUtil.getPrintWriter(this.ambiguityReportFile);
    private Hashtable<String, Integer> ambiguityCategory = new Hashtable();

    public void assignGreedyAnnotations() {
        this.template_freq.clear();
        this.lexicon_freq.clear();
        Parameters.trainingCorpus.removeHeadAnnotations();
        this.extractAllLexTrees();
        int i = 0;
        PrintProgressStatic.start("Assigning heads to sentence:");
        for (TSNode tree : Parameters.trainingCorpus.treeBank) {
            ++i;
            PrintProgressStatic.next();
            if (Parameters.LTSGtype.equals(GreedyTop)) {
                this.assignBestHeadsGreedyTop(tree);
                continue;
            }
            if (!Parameters.LTSGtype.equals(GreedyBottom)) continue;
            this.assignBestHeadsGreedyBottom(tree);
        }
        PrintProgressStatic.end();
        this.printAmbiguityReport();
    }

    public void printAmbiguityReport() {
        this.ambiguityWriter.close();
        float aR = (float)this.ambiguousHeadChoices / (float)this.totalHeadChoices;
        String ambiguityReport = "Ambiguity: " + this.ambiguousHeadChoices + "/" + this.totalHeadChoices + " -> " + aR;
        FileUtil.appendReturn(ambiguityReport, Parameters.logFile);
        FileUtil.printHashtableToFile(this.ambiguityCategory, this.ambiguityCategoryFile);
    }

    public void assignBestHeadsGreedyBottom(TSNode tree) {
        ArrayList<ArrayList<TSNode>> nodesInLevels = tree.getNodesInDepthLevels();
        for (ArrayList<TSNode> levelList : nodesInLevels) {
            for (TSNode TN : levelList) {
                if (TN.isTerminal()) continue;
                if (TN.daughters.length == 1) {
                    if (TN.isPrelexical()) continue;
                    TN.daughters[0].headMarked = true;
                    continue;
                }
                int maxWeight = 0;
                ArrayList<TSNode> maxDaughters = new ArrayList<TSNode>();
                LinkedList<String> maxLeavesOldLex = new LinkedList<String>();
                String cat = "";
                TSNode[] tSNodeArray = TN.daughters;
                int n = TN.daughters.length;
                int n2 = 0;
                while (n2 < n) {
                    int tree_weight;
                    TSNode D = tSNodeArray[n2];
                    D.headMarked = true;
                    TSNode TNcopy = new TSNode(TN);
                    D.headMarked = false;
                    TNcopy.toLexicalizeFrame();
                    TSNode anchor = TNcopy.getAnchor();
                    String oldLex = anchor.label;
                    if (cat.equals("")) {
                        TSNode catNode = anchor.parent.parent;
                        cat = catNode == null ? null : catNode.label;
                    }
                    TNcopy.applyAllConversions();
                    TSNode leaf = TNcopy.getAnchor();
                    if ((Parameters.greedy_punctuation || !leaf.isPunctuation()) && (tree_weight = ((Integer)this.template_freq.get(TNcopy.toString(false, true))).intValue()) >= maxWeight) {
                        if (tree_weight > maxWeight) {
                            maxWeight = tree_weight;
                            maxDaughters.clear();
                            maxLeavesOldLex.clear();
                        }
                        maxDaughters.add(D);
                        maxLeavesOldLex.add(oldLex);
                    }
                    ++n2;
                }
                TSNode bestDaughter = null;
                bestDaughter = !Parameters.greedy_punctuation && maxDaughters.isEmpty() ? this.getAmbiguityChoice(Arrays.asList(TN.daughters), null, TN, "punct", null) : this.getAmbiguityChoice(maxDaughters, maxLeavesOldLex, TN, "" + maxWeight, cat);
                if (bestDaughter == null) continue;
                bestDaughter.headMarked = true;
            }
        }
    }

    public void assignBestHeadsGreedyTop(TSNode tree) {
        List<TSNode> anchors = tree.collectLexicalItems();
        int maxWeight = 0;
        LinkedList<TSNode> maxLeaves = new LinkedList<TSNode>();
        LinkedList<String> ambiguousTrees = new LinkedList<String>();
        TSNode bestLeaf = null;
        if (!Parameters.greedy_punctuation && TSNode.areAllPunctuationLabels(anchors)) {
            bestLeaf = this.getAmbiguityChoice(anchors, null, tree, "punct", null);
        } else {
            String cat = "";
            for (TSNode leaf : anchors) {
                if (!Parameters.greedy_punctuation && leaf.isPunctuation()) continue;
                TSNode eTree = tree.lexicalizedTreeToAnchor(leaf);
                String oldLex = leaf.label;
                if (cat.equals("")) {
                    TSNode catNode = leaf.parent.parent;
                    cat = catNode == null ? null : catNode.label;
                }
                eTree.applyAllConversions();
                int tree_weight = (Integer)this.template_freq.get(eTree.toString(false, true));
                if (tree_weight < maxWeight) continue;
                if (tree_weight > maxWeight) {
                    maxWeight = tree_weight;
                    maxLeaves.clear();
                    ambiguousTrees.clear();
                }
                maxLeaves.add(leaf);
                ambiguousTrees.add(oldLex);
            }
            bestLeaf = this.getAmbiguityChoice(maxLeaves, ambiguousTrees, tree, "" + maxWeight, cat);
        }
        TSNode up = bestLeaf.parent;
        while (up != tree.parent) {
            int prole;
            if (up != tree) {
                up.headMarked = true;
            }
            if ((prole = up.daughters.length) > 1) {
                int d = 0;
                while (d < prole) {
                    TSNode sister = up.daughters[d];
                    if (sister != bestLeaf) {
                        this.assignBestHeadsGreedyTop(sister);
                    }
                    ++d;
                }
            }
            bestLeaf = up;
            up = up.parent;
        }
    }

    private TSNode getAmbiguityChoice(List<TSNode> list, List<String> oldLex, TSNode tree, String label, String category) {
        ++this.totalHeadChoices;
        if (list.size() > 1) {
            if (category == null) {
                category = "nullCat";
                String worning = "null category found in tree: " + tree;
                System.out.println(worning);
                FileUtil.appendReturn(worning, Parameters.logFile);
            }
            this.ambiguityWriter.println(String.valueOf(label) + "\t" + oldLex + "\t" + tree.toString(false, true));
            Utility.increaseStringInteger(this.ambiguityCategory, category, 1);
            ++this.ambiguousHeadChoices;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        switch (Parameters.greedy_ambiguityChoice) {
            case 0: {
                return list.get(Utility.randomInteger(list.size()));
            }
            case 1: {
                return list.get(0);
            }
            case 2: {
                return list.get(list.size() - 1);
            }
            case 3: {
                ++this.secondTotalHeadChoices;
                int maxWeight = -1;
                TSNode maxLeaf = null;
                int index = -1;
                for (String lex : oldLex) {
                    ++index;
                    int tree_weight = (Integer)Parameters.lexiconTable.get(lex);
                    if (tree_weight < maxWeight) continue;
                    maxWeight = tree_weight;
                    maxLeaf = list.get(index);
                }
                return maxLeaf;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        throw new Error("Unresolved compilation problem: \n\tThe constructor Parser(LTSG_Greedy) is undefined\n");
    }
}

