/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import kernels.NodeSetCollector;
import kernels.NodeSetCollectorSimple;
import kernels.NodeSetCollectorStandard;
import settings.Parameters;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelFreqDouble;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import util.ArgumentReader;
import util.FileUtil;
import util.PrintProgress;
import util.Utility;

public class DOP_IO_Log_MT_Smooth
extends Thread {
    public static int threads = 1;
    public static int minFreqFragment = 0;
    public static int maxDepthFragment = Integer.MAX_VALUE;
    public static int endCycle = 10;
    public static int trainingSplits = 10;
    public static double deltaLogLikelihoodThreshold = 1.0E-5;
    public static int printProgressEvery = 20;
    String workingDir;
    ArrayList<TSNodeLabelIndex> trainingCorpus;
    Hashtable<TSNodeLabel, double[]> initialFragmentTableLogFreq;
    Hashtable<TSNodeLabel, double[]> fragmentTableLogFreq;
    Vector<Hashtable<TSNodeLabel, double[]>> smoothedFragmentProbCycles;
    Hashtable<Label, double[]> rootTableLogFreq;
    PrintProgress printProgress;
    int treebankSize;

    public DOP_IO_Log_MT_Smooth(File corpusFile, File fragmentFile, String workingDir) throws Exception {
        this.workingDir = workingDir;
        this.readTreeBank(corpusFile);
        this.readFragmentsFile(fragmentFile);
        this.addCFGfragments();
        this.getRootFreq(this.initialFragmentTableLogFreq);
    }

    private void readTreeBank(File trainingFile) throws Exception {
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(trainingFile);
        this.trainingCorpus = new ArrayList();
        for (TSNodeLabel t : treebank) {
            this.trainingCorpus.add(new TSNodeLabelIndex(t));
        }
        this.treebankSize = treebank.size();
        Parameters.reportLineFlush((String)("Corpus size: " + this.treebankSize));
        File shuffledTreebankFile = new File(String.valueOf(this.workingDir) + "treebank_shuffled.mrg");
        Collections.shuffle(this.trainingCorpus);
        Parameters.reportLineFlush((String)("Printetd shuffled treebank to : " + shuffledTreebankFile));
    }

    public void readFragmentsFile(File fragmentFile) throws Exception {
        this.initialFragmentTableLogFreq = new Hashtable();
        Scanner scan = FileUtil.getScanner(fragmentFile);
        int countFragments = 0;
        int discarded = 0;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            ++countFragments;
            String[] fragmentFreq = line.split("\t");
            String fragmentString = fragmentFreq[0];
            int freq = Integer.parseInt(fragmentFreq[1]);
            if (freq < minFreqFragment) {
                ++discarded;
                continue;
            }
            TSNodeLabel fragment = new TSNodeLabel(fragmentString, false);
            int depth = fragment.maxDepth();
            if (depth > maxDepthFragment) {
                ++discarded;
                continue;
            }
            double logFreq = Math.log(freq);
            this.initialFragmentTableLogFreq.put(fragment, new double[]{logFreq});
        }
        Parameters.reportLine((String)("Read " + countFragments + " fragments"));
        Parameters.reportLineFlush((String)("Discarded " + discarded + " (freq < " + minFreqFragment + " || depth >" + maxDepthFragment + ")"));
        scan.close();
    }

    public void printFragmentLogFreqNormal(File outputFile, Hashtable<TSNodeLabel, double[]> fragmentsLogFreq) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        for (Map.Entry<TSNodeLabel, double[]> e : fragmentsLogFreq.entrySet()) {
            String fragmentString = e.getKey().toString(false, true);
            double freq = Math.exp(e.getValue()[0]);
            if (freq == 0.0) continue;
            pw.println(String.valueOf(fragmentString) + "\t" + freq);
        }
        pw.close();
    }

    public void printFragmentProb(File outputFile, Hashtable<TSNodeLabel, double[]> fragmentsProb) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        for (Map.Entry<TSNodeLabel, double[]> e : fragmentsProb.entrySet()) {
            String fragmentString = e.getKey().toString(false, true);
            double freq = e.getValue()[0];
            if (freq == 0.0) continue;
            pw.println(String.valueOf(fragmentString) + "\t" + freq);
        }
        pw.close();
    }

    /*
     * WARNING - void declaration
     */
    public void addCFGfragments() throws Exception {
        void var2_5;
        Hashtable ruleTable = new Hashtable();
        for (TSNodeLabel tSNodeLabel : this.trainingCorpus) {
            ArrayList<TSNodeLabel> nodes = tSNodeLabel.collectAllNodes();
            for (TSNodeLabel n : nodes) {
                if (n.isLexical) continue;
                String rule = n.cfgRule();
                Utility.increaseInTableInt(ruleTable, rule);
            }
        }
        Parameters.reportLineFlush((String)("Read " + ruleTable.size() + " CFG fragments"));
        boolean bl = false;
        for (Map.Entry e : ruleTable.entrySet()) {
            TSNodeLabel ruleFragment = new TSNodeLabel("( " + (String)e.getKey() + ")", false);
            if (this.initialFragmentTableLogFreq.containsKey(ruleFragment)) continue;
            double logFreq = Math.log(((int[])e.getValue())[0]);
            this.initialFragmentTableLogFreq.put(ruleFragment, new double[]{logFreq});
            ++var2_5;
        }
        Parameters.reportLineFlush((String)("Added " + (int)var2_5 + " CFG fragments"));
    }

    public void getRootFreq(Hashtable<TSNodeLabel, double[]> fragmentTableLogFreq) {
        this.rootTableLogFreq = new Hashtable();
        for (Map.Entry<TSNodeLabel, double[]> e : fragmentTableLogFreq.entrySet()) {
            Label rootLabel = e.getKey().label;
            double logFreq = e.getValue()[0];
            Utility.increaseInTableDoubleLogArray(this.rootTableLogFreq, rootLabel, logFreq);
        }
        Parameters.reportLineFlush((String)("Built root freq. table: " + this.rootTableLogFreq.size() + " entries."));
    }

    @Override
    public void run() {
        try {
            this.runEM();
        }
        catch (InterruptedException e) {
            Parameters.reportError((String)e.getMessage());
        }
    }

    public void runEM() throws InterruptedException {
        this.printInitialFragmentsFreq();
        this.smoothedFragmentProbCycles = new Vector(endCycle);
        int i = 0;
        while (i < endCycle) {
            this.smoothedFragmentProbCycles.add(new Hashtable());
            ++i;
        }
        Vector<ArrayList<TSNodeLabelIndex>> treebankSplits = Utility.splitArrayList(this.trainingCorpus, trainingSplits);
        this.printSplits(treebankSplits);
        int split = 0;
        for (ArrayList<TSNodeLabelIndex> splitCorpus : treebankSplits) {
            this.fragmentTableLogFreq = new Hashtable();
            this.fragmentTableLogFreq.putAll(this.initialFragmentTableLogFreq);
            this.getRootFreq(this.fragmentTableLogFreq);
            this.trainingCorpus = splitCorpus;
            this.treebankSize = this.trainingCorpus.size();
            this.runEMonSplit(split);
            ++split;
        }
        this.printFragmentProbCycles();
    }

    private void printInitialFragmentsFreq() {
        File startFile = new File(String.valueOf(this.workingDir) + "kernelsMUB_CFG_freq_EM_cycle_0.txt");
        this.printFragmentLogFreqNormal(startFile, this.initialFragmentTableLogFreq);
        Parameters.reportLineFlush((String)("Written starting frequencies to file: " + startFile));
    }

    private void printFragmentProbCycles() {
        int cycle = 0;
        for (Hashtable<TSNodeLabel, double[]> fragmentProbCycle : this.smoothedFragmentProbCycles) {
            File outputFile = new File(String.valueOf(this.workingDir) + "kernelsMUB_CFG_freq_EM_cycle_" + ++cycle + ".txt");
            this.printFragmentProb(outputFile, fragmentProbCycle);
            Parameters.reportLineFlush((String)("Written smoothed fragmetns: " + outputFile));
        }
    }

    private void printSplits(Vector<ArrayList<TSNodeLabelIndex>> treebankSplits) {
        int i = 0;
        for (ArrayList<TSNodeLabelIndex> split : treebankSplits) {
            File splitOutputFile = new File(String.valueOf(this.workingDir) + "treebank_split_" + ++i + ".mrg");
            TSNodeLabelIndex.printTreebankToFile(splitOutputFile, split, false, false);
        }
    }

    private void updateProbabilitiesCycle(int cycle) {
        int index = cycle - 1;
        Hashtable<TSNodeLabel, double[]> fragmentProbCycle = this.smoothedFragmentProbCycles.get(index);
        for (Map.Entry<TSNodeLabel, double[]> e : this.fragmentTableLogFreq.entrySet()) {
            double prob = Math.exp(e.getValue()[0]);
            Utility.increaseInTableDoubleLogArray(fragmentProbCycle, e.getKey(), prob);
        }
    }

    public void runEMonSplit(int split) throws InterruptedException {
        Parameters.reportLineFlush((String)("Running IO in split: " + (split + 1)));
        int sentencesPerThreads = this.treebankSize / threads;
        int remainingSentences = this.treebankSize % threads;
        if (remainingSentences != 0) {
            ++sentencesPerThreads;
        }
        int cycle = 0;
        double previousLogLikelihood = Double.NEGATIVE_INFINITY;
        do {
            this.printProgress = new PrintProgress("Iterating Training Corpus:", printProgressEvery, 0);
            EMThreadRunner[] bitParThreadArray = new EMThreadRunner[threads];
            int i = 0;
            while (i < threads) {
                int startIndex = sentencesPerThreads * i;
                EMThreadRunner t = null;
                if (i < threads - 1) {
                    int endIndex = sentencesPerThreads * (i + 1);
                    ArrayList<TSNodeLabelIndex> subtreebank = new ArrayList<TSNodeLabelIndex>(this.trainingCorpus.subList(startIndex, endIndex));
                    t = new EMThreadRunner(subtreebank);
                    t.start();
                } else {
                    ArrayList<TSNodeLabelIndex> subtreebank = new ArrayList<TSNodeLabelIndex>(this.trainingCorpus.subList(startIndex, this.treebankSize));
                    t = new EMThreadRunner(subtreebank);
                    t.run();
                }
                bitParThreadArray[i] = t;
                ++i;
            }
            EMThreadRunner[] eMThreadRunnerArray = bitParThreadArray;
            int t = bitParThreadArray.length;
            int n = 0;
            while (n < t) {
                EMThreadRunner t2 = eMThreadRunnerArray[n];
                t2.join();
                ++n;
            }
            double currentLogLikelihood = 0.0;
            this.fragmentTableLogFreq.clear();
            EMThreadRunner[] eMThreadRunnerArray2 = bitParThreadArray;
            int n2 = bitParThreadArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EMThreadRunner t3 = eMThreadRunnerArray2[n3];
                currentLogLikelihood += t3.currentLogLikelihood;
                this.addAll(t3.fragmentTableLogFreqThread);
                ++n3;
            }
            this.getRootFreq(this.fragmentTableLogFreq);
            this.printProgress.end();
            double deltaLogLikelihood = currentLogLikelihood - previousLogLikelihood;
            Parameters.reportLineFlush((String)("EM cyle " + ++cycle + ". Log-Likelihood: " + currentLogLikelihood + " Delta: " + deltaLogLikelihood));
            if (deltaLogLikelihood <= deltaLogLikelihoodThreshold) break;
            previousLogLikelihood = currentLogLikelihood;
            Parameters.reportLineFlush((String)("Updating probability cycle: " + cycle));
            this.updateProbabilitiesCycle(cycle);
        } while (cycle != endCycle);
    }

    private void addAll(Hashtable<TSNodeLabel, double[]> fragmentTableLogFreqThread) {
        for (Map.Entry<TSNodeLabel, double[]> e : fragmentTableLogFreqThread.entrySet()) {
            Utility.increaseInTableDoubleLogArray(this.fragmentTableLogFreq, e.getKey(), e.getValue()[0]);
        }
    }

    private double updateNewFragmentTableFreq(TSNodeLabelIndex t, Hashtable<TSNodeLabel, double[]> newFragmentTableFreq) {
        NodeSetCollectorSimple setCollector = new NodeSetCollectorSimple();
        HashMap<BitSet, TSNodeLabelFreqDouble> bitSetFreqTable = new HashMap<BitSet, TSNodeLabelFreqDouble>();
        for (Map.Entry<TSNodeLabel, double[]> e : this.fragmentTableLogFreq.entrySet()) {
            DOP_IO_Log_MT_Smooth.getCFGSetCoveringFragment(t, e.getKey(), e.getValue()[0], (NodeSetCollector)setCollector, bitSetFreqTable);
        }
        TSNodeLabelStructure tStructure = new TSNodeLabelStructure(t);
        IOChart pc = new IOChart(setCollector, tStructure, bitSetFreqTable);
        pc.buildChart();
        pc.updateNewFragmentLogFreq(newFragmentTableFreq);
        return pc.getInsideLogProb();
    }

    private static void getCFGSetCoveringFragment(TSNodeLabelIndex t, TSNodeLabel fragment, double fragmentFreq, NodeSetCollector setCollector, HashMap<BitSet, TSNodeLabelFreqDouble> bitSetFreqLogTable) {
        BitSet set;
        if (t.isLexical) {
            return;
        }
        if (t.sameLabel(fragment) && DOP_IO_Log_MT_Smooth.getCFGSetCoveringFragmentNonRecursive(t, fragment, set = new BitSet()) && !set.isEmpty()) {
            setCollector.add(set);
            bitSetFreqLogTable.put(set, new TSNodeLabelFreqDouble(fragment, fragmentFreq));
        }
        TSNodeLabel[] tSNodeLabelArray = t.daughters;
        int n = t.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            TSNodeLabelIndex di = (TSNodeLabelIndex)d;
            DOP_IO_Log_MT_Smooth.getCFGSetCoveringFragment(di, fragment, fragmentFreq, setCollector, bitSetFreqLogTable);
            ++n2;
        }
    }

    private static boolean getCFGSetCoveringFragmentNonRecursive(TSNodeLabelIndex t, TSNodeLabel fragment, BitSet set) {
        if (t.isLexical || fragment.isTerminal()) {
            return true;
        }
        if (!t.sameDaughtersLabel(fragment)) {
            return false;
        }
        int prole = t.prole();
        int i = 0;
        while (i < prole) {
            TSNodeLabel thisDaughter = t.daughters[i];
            TSNodeLabelIndex thisDaughterIndex = (TSNodeLabelIndex)thisDaughter;
            TSNodeLabel otherDaughter = fragment.daughters[i];
            if (!DOP_IO_Log_MT_Smooth.getCFGSetCoveringFragmentNonRecursive(thisDaughterIndex, otherDaughter, set)) {
                return false;
            }
            ++i;
        }
        set.set(t.index);
        return true;
    }

    public synchronized void printProgressNext() {
        this.printProgress.next(printProgressEvery);
    }

    public static void main(String[] args) throws Exception {
        minFreqFragment = 1;
        maxDepthFragment = Integer.MAX_VALUE;
        deltaLogLikelihoodThreshold = 0.0;
        File corpusFile = ArgumentReader.readFileOption(args[0]);
        File fragmentFile = ArgumentReader.readFileOption(args[1]);
        String workingDir = new File(args[2]) + "/";
        threads = ArgumentReader.readIntOption(args[3]);
        minFreqFragment = ArgumentReader.readIntOption(args[4]);
        maxDepthFragment = ArgumentReader.readIntOption(args[5]);
        endCycle = ArgumentReader.readIntOption(args[6]);
        trainingSplits = ArgumentReader.readIntOption(args[7]);
        File workingDirFile = new File(workingDir);
        if (workingDirFile.exists()) {
            workingDirFile = new File(String.valueOf(workingDir) + FileUtil.dateTimeString() + "/");
        }
        workingDirFile.mkdir();
        Parameters.openLogFile((File)new File(String.valueOf(workingDir) + "log.txt"));
        Parameters.reportLine((String)("Working Dir: " + workingDir));
        Parameters.reportLine((String)("Fragment File: " + fragmentFile));
        Parameters.reportLineFlush((String)("Corpus File: " + corpusFile));
        Parameters.reportLine((String)("threads: " + threads));
        Parameters.reportLine((String)("minFreqFragment: " + minFreqFragment));
        Parameters.reportLine((String)("maxDepthFragment: " + maxDepthFragment));
        Parameters.reportLine((String)("endCycle: " + endCycle));
        Parameters.reportLine((String)("trainingSplits: " + trainingSplits));
        Parameters.reportLineFlush((String)("deltaLogLikelihoodThreshold: " + deltaLogLikelihoodThreshold));
        new DOP_IO_Log_MT_Smooth(corpusFile, fragmentFile, workingDir).run();
    }

    protected class EMThreadRunner
    extends Thread {
        ArrayList<TSNodeLabelIndex> subTreebank;
        Hashtable<TSNodeLabel, double[]> fragmentTableLogFreqThread;
        double currentLogLikelihood;

        public EMThreadRunner(ArrayList<TSNodeLabelIndex> subTreebank) {
            this.subTreebank = subTreebank;
            this.fragmentTableLogFreqThread = new Hashtable();
            this.currentLogLikelihood = 0.0;
        }

        @Override
        public void run() {
            int i = 0;
            for (TSNodeLabelIndex t : this.subTreebank) {
                if (++i == printProgressEvery) {
                    DOP_IO_Log_MT_Smooth.this.printProgressNext();
                    i = 0;
                }
                double logInsideProb = DOP_IO_Log_MT_Smooth.this.updateNewFragmentTableFreq(t, this.fragmentTableLogFreqThread);
                this.currentLogLikelihood += logInsideProb;
            }
        }
    }

    class IOChart {
        NodeSetCollectorSimple setCollector;
        TSNodeLabelStructure t;
        int totalNodes;
        IOSubNode[] IOSubNodesChart;
        NodeSetCollectorStandard[] nodesCollector;
        HashMap<BitSet, TSNodeLabelFreqDouble> bitSetFreqTable;

        public IOChart(NodeSetCollectorSimple setCollector, TSNodeLabelStructure t, HashMap<BitSet, TSNodeLabelFreqDouble> bitSetFreqTable) {
            this.setCollector = setCollector;
            this.t = t;
            this.totalNodes = t.length;
            this.IOSubNodesChart = new IOSubNode[this.totalNodes];
            this.nodesCollector = new NodeSetCollectorStandard[this.totalNodes];
            this.bitSetFreqTable = bitSetFreqTable;
        }

        public void buildChart() {
            for (BitSet bs : this.setCollector.bitSetSet) {
                int firstIndex = bs.nextSetBit(0);
                if (this.nodesCollector[firstIndex] == null) {
                    this.nodesCollector[firstIndex] = new NodeSetCollectorStandard();
                }
                this.nodesCollector[firstIndex].add(bs);
            }
            this.buildInsideProb();
            this.buildOutsideProb();
        }

        public double getInsideLogProb() {
            return this.IOSubNodesChart[0].insideLogProb;
        }

        private void buildInsideProb() {
            int i = this.totalNodes - 1;
            while (i >= 0) {
                if (!this.t.structure[i].isLexical) {
                    this.buildInsideProb(i);
                }
                --i;
            }
        }

        private void buildInsideProb(int index) {
            NodeSetCollectorStandard setCollector = this.nodesCollector[index];
            TSNodeLabelIndex root = this.t.structure[index];
            double rootLogFreq = DOP_IO_Log_MT_Smooth.this.rootTableLogFreq.get(root.label)[0];
            IOSubNode IOSubNodeIndex = new IOSubNode();
            for (BitSet initialSubTree : setCollector.bitSetArray) {
                ArrayList<Integer> subSitesIndexes = new ArrayList<Integer>();
                this.collectSubSites(root, initialSubTree, subSitesIndexes);
                double initialSubTreeInsideLogProb = 0.0;
                for (int subSiteIndex : subSitesIndexes) {
                    double subSiteInsideLogProb = this.IOSubNodesChart[subSiteIndex].insideLogProb;
                    initialSubTreeInsideLogProb += subSiteInsideLogProb;
                }
                TSNodeLabelFreqDouble treeDouble = this.bitSetFreqTable.get(initialSubTree);
                double initialSubTreeFreq = treeDouble.freq;
                TSNodeLabel initialFragment = treeDouble.tree;
                IOSubNodeIndex.addDerivation(initialFragment, subSitesIndexes, initialSubTreeInsideLogProb += initialSubTreeFreq - rootLogFreq);
            }
            this.IOSubNodesChart[index] = IOSubNodeIndex;
        }

        private void collectSubSites(TSNodeLabelIndex root, BitSet initialSubTree, ArrayList<Integer> subSitesIndexes) {
            TSNodeLabel[] tSNodeLabelArray = root.daughters;
            int n = root.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel d = tSNodeLabelArray[n2];
                if (d.isLexical) {
                    return;
                }
                TSNodeLabelIndex di = (TSNodeLabelIndex)d;
                int index = di.index;
                if (!initialSubTree.get(index)) {
                    subSitesIndexes.add(index);
                } else {
                    this.collectSubSites(di, initialSubTree, subSitesIndexes);
                }
                ++n2;
            }
        }

        private void buildOutsideProb() {
            this.IOSubNodesChart[0].outsideLogProb = 0.0;
            int i = 0;
            while (i < this.totalNodes) {
                if (!this.t.structure[i].isLexical) {
                    this.buildOutsideProb(i);
                }
                ++i;
            }
        }

        private void buildOutsideProb(int index) {
            IOSubNode IOSubNodeIndex = this.IOSubNodesChart[index];
            double ousideLogProb = IOSubNodeIndex.outsideLogProb;
            for (InitFragmentDerivations ifd : IOSubNodeIndex.partialDerivations) {
                double initialFragmInsideLogProb = ifd.initFragmentInsideLogProb;
                for (int subSite : ifd.subSites) {
                    double subSiteInsideLogProb = this.IOSubNodesChart[subSite].insideLogProb;
                    double outsideLogProbToAdd = ousideLogProb + initialFragmInsideLogProb - subSiteInsideLogProb;
                    IOSubNode subSiteDerivation = this.IOSubNodesChart[subSite];
                    subSiteDerivation.addOutisdeProb(outsideLogProbToAdd);
                }
            }
        }

        public void updateNewFragmentLogFreq(Hashtable<TSNodeLabel, double[]> newFragmentTableFreq) {
            double insideLogProbTOP = this.IOSubNodesChart[0].insideLogProb;
            int i = 0;
            while (i < this.totalNodes) {
                if (!this.t.structure[i].isLexical) {
                    IOSubNode IOSubNodeIndex = this.IOSubNodesChart[i];
                    double ousideLogProb = IOSubNodeIndex.outsideLogProb;
                    for (InitFragmentDerivations ifd : IOSubNodeIndex.partialDerivations) {
                        TSNodeLabel initialFragment = ifd.intialFragment;
                        double initialFragmInsideLogProb = ifd.initFragmentInsideLogProb;
                        double newFreqToAdd = ousideLogProb + initialFragmInsideLogProb - insideLogProbTOP;
                        Utility.increaseInTableDoubleLogArray(newFragmentTableFreq, initialFragment, newFreqToAdd);
                    }
                }
                ++i;
            }
        }
    }

    class IOSubNode {
        ArrayList<InitFragmentDerivations> partialDerivations = new ArrayList();
        double insideLogProb = Double.NEGATIVE_INFINITY;
        double outsideLogProb = Double.NEGATIVE_INFINITY;

        public void addDerivation(TSNodeLabel intialFragment, ArrayList<Integer> subSites, double initFragmInsideLogProb) {
            this.partialDerivations.add(new InitFragmentDerivations(intialFragment, subSites, initFragmInsideLogProb));
            this.insideLogProb = Utility.logSum(this.insideLogProb, initFragmInsideLogProb);
        }

        public void addOutisdeProb(double outsideLogProbToAdd) {
            this.outsideLogProb = Utility.logSum(this.outsideLogProb, outsideLogProbToAdd);
        }
    }

    class InitFragmentDerivations {
        TSNodeLabel intialFragment;
        ArrayList<Integer> subSites;
        double initFragmentInsideLogProb;

        public InitFragmentDerivations(TSNodeLabel intialFragment, ArrayList<Integer> subSites, double initFragmentInsideLogProb) {
            this.intialFragment = intialFragment;
            this.subSites = subSites;
            this.initFragmentInsideLogProb = initFragmentInsideLogProb;
        }
    }
}

